@extends('layouts.layout')
@section('title', 'Users')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif

            <h2>Users Management
                <a href="{{ route('users.create') }}" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new User</a>
            </h2>
        <br/>
    <div class="widget">
        <div class="widget-header"> <i class="icon-th-list"></i>
            <h3>Users Management</h3>
        </div>
        <!-- /widget-header -->
        <div class="widget-content widget-table action-table">
            <table class="table table-condensed table-stripe ddt-responsive" id="table">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Last Updated</th>
                    <th class="td-actions">Actions</th>
                </tr>
                </thead>
            </table>
        </div>
        <!-- /widget-content -->
    </div>
    <!-- /widget -->
    </div>
    <script>
        $(function() {
            var dtListUsers = $('#table').DataTable({
                processing: true,
                serverSide: true,
                dom: '<"wrapper"lf<"customefilter"><t>ip>',
                ajax: '{{ route('loaddata.index',['action' => 'users']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'email', name: 'email' },
                    { data: 'rname', name: 'rname' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
            $('.customefilter').html("<label>Filter By Role: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                "                            <option value=\"0\">All Roles</option>\n" +
                "                            @foreach ($roles as $role => $value)\n" +
                "                                <option value=\"{{ $role }}\"> {{ $value }}</option>\n" +
                "                            @endforeach\n" +
                "                        </select>");
            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
                var new_url = '{{ url('loaddata') }}?action=userfiltertroles&status=' + filter_value;
                dtListUsers.ajax.url(new_url).load();

            } );
        });
    </script>
    <style>
        .customefilter{
            width:300px;
            float:right;
        }
    </style>
@endsection
