<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: *');
header('Access-Control-Allow-Headers: *');

Route::POST('usertickets', 'API\TicketsController@show');
Route::POST('usertickets1', 'API\TicketsController@edit');
Route::POST('create', 'API\TicketsController@store');
Route::POST('getsubcatsession', 'API\TicketsController@getsubcatsession');
Route::get('usertickets', 'API\TicketsController@getpriority');
Route::get('getcategory', 'API\TicketsController@getcategory');
Route::get('/sub_category/get/{id}', 'API\TicketsController@getSubcategory');

Route::post('ticketcomments', 'API\TicketsController@ticketcomments');
Route::post('updatemark', 'API\TicketsController@updatemark');

Route::get('livesearch','API\TicketsController@livesearch');

//store suggestion-trackings
Route::POST('suggestion-trackings', 'API\SuggestiontrackingsController@store');