<?php $__env->startSection('content'); ?>



<div class="account-container register">

    <div class="content clearfix">

        <form method="POST" action="<?php echo e(route('tickets.store')); ?>" class="form-horizontal" id="form">
            <?php echo csrf_field(); ?>
            <legend>Create New Ticket</legend>

            <fieldset>

                <div class="control-group">
                    <label class="control-label" for="username">Email:</label>
                    <div class="controls">
                        <input type="text" name="email" class="span6" value="jaydeep@simprosys.net">
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group">
                    <label class="control-label" for="firstname">App:</label>
                    <div class="controls">
                        <select name="category_id" class="span3">
                            <option value="">Select App</option>
                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('category_id')): ?>
                            <span class="text-danger"><?php echo e($errors->first('category_id')); ?></span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group">
                    <label class="control-label" for="firstname">Category:</label>
                    <div class="controls">
                        <select name="sub_category_id" class="span3">
                            <option>Select Category</option>

                        </select>
                        <?php if($errors->has('sub_category_id')): ?>
                            <span class="text-danger"><?php echo e($errors->first('sub_category_id')); ?></span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group">
                    <label class="control-label" for="firstname">Subject:</label>
                    <div class="controls">
                        <input class="span6" name="subject" type="text" id="subject" placeholder="A brief of your issue ticket
">		   <?php if($errors->has('subject')): ?>
                            <span class="text-danger"><?php echo e($errors->first('subject')); ?></span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group">
                    <label class="control-label" for="firstname">Description:</label>
                    <div class="controls">
                        <textarea class="span6" name="content" cols="50" id="content" placeholder="Describe your issue here in details"></textarea>
                        <?php if($errors->has('content')): ?>
                            <span class="text-danger"><?php echo e($errors->first('content')); ?></span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group">
                    <label class="control-label" for="firstname">Priority:</label>
                    <div class="controls">
                        <select name="priority_id" class="span3">
                            <option value="">Select Priority</option>
                            <?php $__currentLoopData = $priority; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prity->id); ?>" <?php if($prity->default_set == 1): ?> selected <?php endif; ?>><?php echo e($prity->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('priority_id')): ?>
                            <span class="text-danger"><?php echo e($errors->first('priority_id')); ?></span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <div class="control-group <?php echo e($errors->has('g-recaptcha-response') ? ' has-error' : ''); ?>">
                    <div class="controls">
                        <div class="g-recaptcha" data-sitekey="<?php echo e(env('CAPTCHA_SITE_KEY')); ?>" data-callback="correctCaptcha"></div>
                        <?php if($errors->has('g-recaptcha-response')): ?>
                            <span class="invalid-feedback" style="display: block;">
                        <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                    </span>
                        <?php endif; ?>
                    </div> <!-- /controls -->
                </div> <!-- /control-group -->

                <br />

                <input type="hidden" name="domain_name" class="form-control" value="<?php echo e($domainname); ?>">
                <input type="hidden" name="ticketable_type" class="form-control" value="0">
                <input type="hidden" name="ticketable_id" class="form-control" value="2">
                <input type="hidden" name="status_id" class="form-control" value="<?php echo e($statuses[0]->id); ?>">
                <div class="form-actions" style="display:none;">
                <!-- <a href="<?php echo e(route('tickets.index')); ?>" class="btn btn-default">Back</a> -->
                    <input class="btn btn-primary" type="submit" value="Submit" id="submitbtn">
                </div> <!-- /form-actions -->

            </fieldset>
        </form>

    </div> <!-- /content -->

</div> <!-- /account-container -->


<?php $__env->stopSection(); ?>
<?php echo $__env->make('tickets.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>