Country flags in single CSS sprite
==================================

CSS Sprites - a method to optimize page loads by combining a large number of small images into one. 

## Usage

Include CSS file in your HTML code then insert a transparent 1x1 pixel image with classes `flag` and `flag-{country code}`. The country code is in the format ISO 3166-1 alpha-2:

```html
<html>
    <head>
        <link href="flags.css" rel=stylesheet type="text/css">
    </head>
    <body>
        <img src="blank.gif" class="flag flag-cz" alt="Czech Republic" />
    </body>
</html>
```

## Included flags


* Afghanistan (af)
* Aland Islands (ax)
* Albanien (al)
* Algerien (dz)
* Amerikanisch-Samoa (as)
* Amerikanische Jungferninseln (vi)
* Andorra (ad)
* Angola (ao)
* Anguilla (ai)
* Antigua und Barbuda (ag)
* Argentinien (ar)
* Armenien (am)
* Aruba (aw)
* Aserbaidschan (az)
* Australien (au)
* Bahamas (bs)
* Bahrain (bh)
* Bangladesch (bd)
* Barbados (bb)
* Belgien (be)
* Belize (bz)
* Benin (bj)
* Bermuda (bm)
* Bhutan (bt)
* Bolivien (bo)
* Bosnien und Herzegowina (ba)
* Botswana (bw)
* Brasilien (br)
* Britische Jungferninseln (vg)
* Brunei (bn)
* Bulgarien (bg)
* Burkina Faso (bf)
* Burundi (bi)
* Cabo Verde (cv)
* Cambodia (kh)
* Chile (cl)
* Cookinseln (ck)
* Costa Rica (cr)
* Cote d&#39;Ivoire (ci)
* Curacao (cw)
* Deutschland (de)
* Dominica (dm)
* Dominikanische Republik (do)
* Dschibuti (dj)
* Dänemark (dk)
* Ecuador (ec)
* El Salvador (sv)
* Eritrea (er)
* Estland (ee)
* Europäische Union (eu)
* Falklandinseln (fk)
* Fidschi (fj)
* Finnland (fi)
* Frankreich (fr)
* Französisch-Polynesien (pf)
* French Southern Territories (tf)
* Färöer  (fo)
* Föderierte Staaten von Mikronesien (fm)
* Gabun (ga)
* Gambia (gm)
* Georgien (ge)
* Ghana (gh)
* Gibraltar (gi)
* Grenada (gd)
* Griechenland (gr)
* Grönland (gl)
* Guam (gu)
* Guatemala (gt)
* Guernsey (gg)
* Guinea (gn)
* Guinea-Bissau (gw)
* Guyana (gy)
* Haiti (ht)
* Honduras (hn)
* Hongkong (hk)
* Indien (in)
* Indonesien (id)
* Irak (iq)
* Iran (ir)
* Irland (ie)
* Island (is)
* Isle of Man (im)
* Israel (il)
* Italien (it)
* Jamaika (jm)
* Japan (jp)
* Jemen (ye)
* Jersey (je)
* Jordanien (jo)
* Kaimaninseln (ky)
* Kamerun (cm)
* Kanada (ca)
* Kanarische Inseln (ic)
* Kasachstan (kz)
* Katar (qa)
* Kenia (ke)
* Kirgisistan (kg)
* Kiribati (ki)
* Kolumbien (co)
* Komoren (km)
* Kongo (cg)
* Kongo, Die Demokratische Republik (cd)
* Kroatien (hr)
* Kuba (cu)
* Kuwait (kw)
* Laos (la)
* Lesotho (ls)
* Lettland (lv)
* Libanon (lb)
* Liberia (lr)
* Libya (ly)
* Liechtenstein (li)
* Litauen (lt)
* Luxemburg (lu)
* Macao (mo)
* Madagaskar (mg)
* Malawi (mw)
* Malaysia (my)
* Malediven (mv)
* Mali (ml)
* Malta (mt)
* Marokko (ma)
* Marshallinseln (mh)
* Martinique (mq)
* Mauretanien (mr)
* Mauritius (mu)
* Mayotte (yt)
* Mazedonien (mk)
* Mexiko (mx)
* Moldawien (md)
* Monaco (mc)
* Mongolei (mn)
* Montenegro (me)
* Montserrat (ms)
* Mosambik (mz)
* Myanmar (mm)
* Namibia (na)
* Nauru (nr)
* Nepal (np)
* Neukaledonien (nc)
* Neuseeland (nz)
* Nicaragua (ni)
* Niederlande (nl)
* Niederländische Antillen (an)
* Niger (ne)
* Nigeria (ng)
* Niue (nu)
* Nordkorea (kp)
* Norfolkinsel (nf)
* Norwegen (no)
* Nördliche Marianen (mp)
* Oman (om)
* Pakistan (pk)
* Palau (pw)
* Palästinensische Autonomiegebiete (ps)
* Panama (pa)
* Papua-Neuguinea (pg)
* Paraguay (py)
* Peru (pe)
* Philippinen (ph)
* Pitcairn (pn)
* Polen (pl)
* Portugal (pt)
* Puerto Rico (pr)
* Ruanda (rw)
* Rumänien (ro)
* Russland (ru)
* Saint Barthelemy (bl)
* Saint Martin (mf)
* Salomonen (sb)
* Sambia (zm)
* Samoa (ws)
* San Marino (sm)
* Sao Tome und Principe (st)
* Saudi-Arabien (sa)
* Schweden (se)
* Schweiz (ch)
* Senegal (sn)
* Serbien (rs)
* Seychellen (sc)
* Sierra Leone (sl)
* Singapur (sg)
* Slowakei (sk)
* Slowenien (si)
* Somalia (so)
* South Georgia and the South Sandwich Islands (gs)
* Spanien (es)
* Sri Lanka (lk)
* St. Helena (sh)
* St. Kitts und Nevis (kn)
* St. Lucia (lc)
* St. Vincent und die Grenadinen (vc)
* Sudan (sd)
* Suriname (sr)
* Swaziland (sz)
* Syrien (sy)
* Süd-Sudan (ss)
* Südafrika (za)
* Südkorea (kr)
* Tadschikistan (tj)
* Taiwan (tw)
* Tansania (tz)
* Thailand (th)
* Timor (tl)
* Togo (tg)
* Tokelau (tk)
* Tonga (to)
* Trinidad und Tobago (tt)
* Tschad (td)
* Tschechien (cz)
* Tunesien (tn)
* Turkmenistan (tm)
* Turks- und Caicosinseln (tc)
* Tuvalu (tv)
* Türkei (tr)
* Uganda (ug)
* Ukraine (ua)
* Ungarn (hu)
* Uruguay (uy)
* Usbekistan (uz)
* Vanuatu (vu)
* Vatikanstadt (va)
* Venezuela (ve)
* Vereinigte Arabische Emirate (ae)
* Vereinigte Staaten (us)
* Vereinigtes Königreich (gb)
* Vietnam (vn)
* Volksrepublik China (cn)
* Wallis und Futuna (wf)
* Weißrussland (by)
* Westsahara (eh)
* Zentralafrikanische Republik (cf)
* Zimbabwe (zw)
* Zypern (cy)
* Ägypten (eg)
* Äquatorial-Guinea (gq)
* Äthiopien (et)
* Österreich (at)

## Links

* [CSS Flag Sprites generator](https://www.flag-sprites.com/ "Country flags in single CSS sprite")
* [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)