<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use Datatables;
class LoadDataController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth',['except' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $action = $request->action;

        switch ($request->action) {
            default:
                return response()->json(['message' => 'Invalid Request']);
                break;
            case "suggestions":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "suggestions";
                break;
            case "subsuggestion":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "suggestions";
                break;
            case "comments":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "comments";
                break;
            case "emailtemplates":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "emailtemplates";
                break;
            case "roles":
                $aColumns = ['created_at', 'default_set', 'name', 'id'];
                $sTable = "roles";
                break;
            case "categories":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "categories";
                break;
            case "users":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "users";
        }



        $table = DB::table($sTable);

        //mysql Join, select where all condition

 
        if ($action == 'suggestions') {
            $table->join('statuses', 'suggestions.status_id', '=', 'statuses.id');
            $table->join(DB::raw('(select suggestions_id, count(*) as totalvotes from votes group by suggestions_id) as votes'), 
            function($join)
            {
               $join->on('votes.suggestions_id', '=', 'suggestions.id');
            });
            $table->select('suggestions.*', 'statuses.name AS sname','statuses.color AS scolor','statuses.tooltips AS stooltips','votes.totalvotes');
            $table->whereNull('suggestions.deleted_at');
            if($request->flagstatus != 99 && $request->flagstatus != 1 && $request->flagstatus != 0) {
                $table->where("suggestions.status_id", "=", $request->flagstatus);
            }
            if($request->flagstatus && $request->flagstatus == 1) {
                $table ->whereIn("suggestions.status_id", [2,3,4]);
            }
            $table->orderBy('suggestions.updated_at', 'desc');
        }
        if ($action == 'subsuggestion') {
            $table->join('statuses', 'suggestions.status_id', '=', 'statuses.id');
            $table->join(DB::raw('(select suggestions_id, count(*) as totalvotes from votes group by suggestions_id) as votes'), 
            function($join)
            {
               $join->on('votes.suggestions_id', '=', 'suggestions.id');
            });
            $table->select('suggestions.*', 'statuses.name AS sname','statuses.color AS scolor','statuses.tooltips AS stooltips','votes.totalvotes');
            $table->whereNull('suggestions.deleted_at');
            if($request->status && $request->status != 0) {
                $table->where("suggestions.categories_id", "=", $request->status);
            }
            if($request->pstatus && $request->pstatus != 0) {
                $table->where("suggestions.status_id", "=", $request->pstatus);
            }
            $table->orderBy('suggestions.updated_at', 'desc');
        }
        
        if ($action == 'comments') {
            $table->select('comments.*', 'suggestions.suggestion_title AS suggestion_title','suggestions.id as sugid');
            $table->join('suggestions', 'suggestions.id', '=', 'comments.suggestions_id');
            $table->orderBy('comments.id', 'desc');
        }

        if ($action == 'emailtemplates') {
             $table->whereNull('deleted_at');
             $table->orderBy('updated_at', 'desc');
        }
        if ($action == 'roles') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }
        if ($action == 'users') {
            $table->join('roles', 'users.role_id', '=', 'roles.id');
            $table->select('users.*', 'roles.name AS rname','roles.color AS rcolor');
            $table->whereNull('users.deleted_at');
            $table->orderBy('users.updated_at', 'desc');
        }
        if ($action == 'categories') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }

        // finally get data from table
        $table = $table->get();

      //dd($table);

                if ($action == 'categories') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'admin-categories.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'admin-categories.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the App: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                 ->editColumn('shortname', function ($table) {
                    if (empty($table->shortname)) {
                        return "-";
                    }else{
                        return "$table->shortname";
                    }
                })
            
                            ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
 

        if ($action == 'suggestions' || $action =='subsuggestion') {
            return Datatables::of($table)
                ->editColumn('suggestion_title', '<a href="{{ route(\'admin-suggestions.show\', $id) }}">{{ str_limit( $suggestion_title ,50) }}</a>')
                ->editColumn('totalvisit', '{{$totalvisit or 0}}')
                ->editColumn('sname', '<span class="statuslabel {{$scolor}}" data-toggle="tooltip" title="{{$stooltips}}">{{$sname}}</span>')
                ->editColumn('created_at', '<time title="{{$created_at}}">{{ Carbon\Carbon::parse($created_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }


        if ($action == 'comments') {
            return Datatables::of($table)
                ->editColumn('suggestion_title', '<a href="{{ route(\'admin-suggestions.show\', $sugid) }}#comment{{$id}}">{{ str_limit( $suggestion_title ,50) }}</a>')
                ->editColumn('message', '{{ str_limit( $message ,50) }}')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'emailtemplates') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'admin-email-templates.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'admin-email-templates.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Email Templates: {{$title}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
        if ($action == 'roles') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'admin-roles.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'admin-roles.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Role: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('name', '<span style="color: {{$color}}">{{$name}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->editColumn('default_set', '{{ $default_set == \'0\' ? \' - \' : \'Default\' }}')
                ->escapeColumns([])
                ->toJson();
        }

                if ($action == 'users' || $action =='userfiltertroles') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'admin-users.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'admin-users.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the User: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('email', function ($table) {
                    if (empty($table->email)) {
                        return "-";
                    }else{
                        return "$table->email";
                    }
                })
                ->editColumn('rname', '<span style="color: {{$rcolor}}">{{$rname}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

    }

}
