<?php

namespace App\Http\Controllers;

use App\Suggestions;
use DB;
use Illuminate\Http\Request;
use App\Rules\Captcha;

class SuggestionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //dd($request->ip());


        //$dd($request->all());
       //$fullURL = \Request::fullUrl();
       //$data = parse_str($fullURL);
        if (!empty($request->order) && !empty($request->filter)) { 
            $order = $request->order;
             $filter = $request->filter;
        } else {
             $order = "popular";
             $filter = "all";
        }
        //dd($filter);
        switch ($filter) {
            default:
                $aColumns = "All";
                $status_id = [1,2,3,4,5];
                $not_status_id = 0;
                break;
            case "all":
                $aColumns = "All";
                $status_id = [1,2,3,4,5];
                $not_status_id = 0;
                break;
            case "allexceptdone":
                $aColumns = "All except done";
                $status_id = [2,3,4];
                $not_status_id = 6;
                break;
            case "underconsideration":
                $aColumns = "Under consideration";
                $status_id = [2];
                $not_status_id = 6;
                break;
            case "planned":
                $aColumns = "Planned";
                $status_id = [3];
                $not_status_id = 6;
                break;
            case "notplanned":
                $aColumns = "Not planned";
                $status_id = [4];
                $not_status_id = 6;
                break;
            case "done":
                $aColumns = "Done";
                $status_id = [5];
                $not_status_id = 6;
                break;
        }

        if ($order == "new")
        {
            $order_status = "suggestions.created_at";
        }
        else
        {
            $order_status = "totalvotes";
        }
        

        $query = DB::table('suggestions')
        ->select('suggestions.*','comments.totalcomments','votes.upvotedt','votes.totalvotes','statuses.id as sid','statuses.name','statuses.color','statuses.tooltips')    
        ->join(DB::raw('(select suggestions_id, MAX(created_at) as upvotedt, count(*) as totalvotes from votes group by suggestions_id) as votes'), 
        function($join)
        {
           $join->on('votes.suggestions_id', '=', 'suggestions.id');
        })
        ->leftjoin(DB::raw('(select suggestions_id, count(*) as totalcomments from comments group by suggestions_id) as comments'), 
        function($join)
        {
           $join->on('comments.suggestions_id', '=', 'suggestions.id');
        })
        ->join("statuses","suggestions.status_id","=","statuses.id")
        //->where("suggestions.status_id", "!=" , $not_status_id)
        ->whereIn("suggestions.status_id", $status_id)
        ->whereNull('suggestions.deleted_at')
        ->orderBy($order_status, 'desc');

        if ($filter == 'all')
        {
            $query->orwhere("suggestions.suggestor_ip", $request->ip());
            $query->where("suggestions.status_id", "!=" , $not_status_id);
        }

        $suggestions_list = $query->get();



        $suggestions_all_list_count = DB::table('suggestions')
        ->select('suggestions.*','comments.totalcomments','votes.totalvotes','statuses.id as sid','statuses.name','statuses.color','statuses.tooltips')    
        ->join(DB::raw('(select suggestions_id, count(*) as totalvotes from votes group by suggestions_id) as votes'), 
        function($join)
        {
           $join->on('votes.suggestions_id', '=', 'suggestions.id');
        })
        ->leftjoin(DB::raw('(select suggestions_id, count(*) as totalcomments from comments group by suggestions_id) as comments'), 
        function($join)
        {
           $join->on('comments.suggestions_id', '=', 'suggestions.id');
        })
        ->join("statuses","suggestions.status_id","=","statuses.id")
        ->whereIn("suggestions.status_id", [1,2,3,4,5])
        ->orwhere("suggestions.suggestor_ip", $request->ip())
        ->whereNull('suggestions.deleted_at')
        ->orderBy($order_status, 'desc')
        ->count();


            $status_list = DB::table('statuses')
            ->select('statuses.*',DB::raw("COUNT(suggestions.status_id) as totalsuggestions"))
            ->leftjoin("suggestions","suggestions.status_id","=","statuses.id")
            ->groupBy("statuses.id")
            ->whereNull('statuses.deleted_at')
            ->where('statuses.id', '!=' , 6)
            ->get();
        //dd($suggestions_list);
        return view('suggestions.index',compact('suggestions_list','status_list','order','filter','aColumns','suggestions_all_list_count'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

      $categories = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
       return view('suggestions.add',compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      //dd($request->all());

      
      
        try
        {
            request()->validate([
            'suggestion_title' => 'required',
            'suggestor_email' => 'required|email',
            'suggestor_name' => 'required',
            'suggestion_description' =>'required',
            'g-recaptcha-response' => new Captcha(),
            ]);

            $title_slug = str_slug($request['suggestion_title'], '-');
            //$ip_logs_data = \Location::get("192.206.151.131");

           //var_dump($ip_logs_data);
            $ip_logs_data = \Location::get($request->ip());


            DB::table('suggestions')->insert([
            'categories_id' => $request['suggestion_app'],
            'suggestion_title' => $request['suggestion_title'],
            'suggestion_slug' => $title_slug,
            'suggestion_description' => $request['suggestion_description'],
            'suggestor_name' => $request['suggestor_name'],
            'suggestor_email' => $request['suggestor_email'],
            'ip_logs' => json_encode($ip_logs_data),
            'suggestor_ip' => $request->ip(),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);

            $suggestions_id = DB::getPdo()->lastInsertId();

             DB::table('votes')->insert([
            'suggestions_id' => $suggestions_id,
            'vote_ip' => $request->ip(),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);

            $suggestions_list = DB::table('suggestions')->where('id', $suggestions_id)->whereNull('deleted_at')->first();
            return redirect('suggestions/'.$suggestions_id)->with('success','Your suggestion was added and is awaiting moderation.');

        }
        catch(\Illuminate\Database\QueryException $e)
        {
            //return View::make('edit.create')->with('status','<strong>'.$siteName.' Site already exist!</strong>'); 
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function show($id,Request $request)
    {

          $get_user_pageview =DB::table('pageviews')
        ->where('suggestions_id',$id)
        ->where('user_ip',$request->ip())
        ->whereDate('created_at',date('Y-m-d'))
        ->first();
        //dd($get_user_pageview->totalvisit);
         
        if(is_null($get_user_pageview))
        {
            DB::table('pageviews')->insert([
            'suggestions_id' => $id,
            'user_ip' => $request->ip(),
            'totalvisit' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);
        }
        else
        {
          $visitor = $get_user_pageview->totalvisit + 1;
          $update = DB::table('pageviews') 
          ->where('suggestions_id',$id)
          ->where('user_ip',$request->ip())
          ->whereDate('created_at',date('Y-m-d'))
          ->update(array('totalvisit' => $visitor)); 
        }

        $suggestions = DB::table('suggestions')
        ->select('suggestions.*','statuses.id as stid','statuses.name','statuses.color','statuses.tooltips')    
        ->join("statuses","suggestions.status_id","=","statuses.id")
        ->where('suggestions.id', $id)
        ->whereNull('suggestions.deleted_at')->first();
        //dd($suggestions);
        $comments_list = DB::table('comments')->where('suggestions_id', $id)->whereNull('deleted_at')->get();

        $total_votes = DB::table("votes")->where('suggestions_id', $id)->whereNull('deleted_at')->count();
        
        $updated_last_votes = DB::table("votes")->where('suggestions_id', $id)->whereNull('deleted_at')->orderBy('id', 'desc')->take(1)->get();

        $my_votes_active = DB::table('votes')
                        ->where('suggestions_id',$id)
                        ->where('vote_ip',\Request::ip())
                        ->count();
        return view('suggestions.show',compact('suggestions','comments_list','total_votes','my_votes_active','updated_last_votes'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $suggestions_datas = DB::table('suggestions')->where('id', $id)->get();
        $categories = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        return view('suggestions.edit',compact('suggestions_datas','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $title_slug = str_slug($request->get('suggestion_title'), '-');
        $suggestions= \App\Suggestions::find($id);
        $suggestions->categories_id=$request->get('suggestion_app');
        $suggestions->suggestion_title=$request->get('suggestion_title');
        $suggestions->suggestion_slug=$title_slug;
        $suggestions->suggestion_description=$request->get('suggestion_description');
        $suggestions->suggestor_name=$request->get('suggestor_name');
        $suggestions->suggestor_email=$request->get('suggestor_email');
        $suggestions->suggestor_ip=$request->ip();
        $suggestions->created_at=date('Y-m-d H:i:s');
        $suggestions->updated_at=date('Y-m-d H:i:s');
        $suggestions->save();
        return redirect('suggestions/'.$id)->with('success','Your changes have been saved.');




         // $affected = DB::table('tickets')->where('id', '=', $request['ticket_id'])->update(array('ticketable_type' => 1,'updated_at' => date('Y-m-d H:i:s')));


    }
    
    public function searchsuggestions(Request $request)
    {
          //dd($request->all());
        return Suggestions::where('suggestion_title', 'LIKE', '%'.$request->q.'%')->get();
    }

    
    public function searchmatchsuggestions(Request $request)
    {
          //dd($request->all());
      return Suggestions::where('suggestion_title', 'LIKE', '%'.$request->q.'%')->get();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function destroy(Suggestions $suggestions)
    {
        //
    }
}
