<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller as Controller;

use App\Categories;
use DB;
use Datatables;
use Illuminate\Http\Request;

class CategoriesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin/categories.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required'
        ], [
            'name.required' => 'App Name is required'
        ]);
        Categories::create($request->all());
        return redirect('admin-categories')
            ->with('success','App created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function show(Categories $categories)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = \App\Categories::find($id);
        return view('admin/categories.edit',compact('categories','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required'
        ], [
            'name.required' => 'App Name is required'
        ]);
        $categories= \App\Categories::find($id);
        $categories->name=$request->get('name');
        $categories->shortname=$request->get('shortname');
        $categories->shop_prefix=$request->get('shop_prefix');
        $categories->app_url=$request->get('app_url');
        $categories->help_doc_url=$request->get('help_doc_url');

        $categories->save();
       // return redirect('categories');
        return redirect('admin-categories')
            ->with('success','App updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $categories = \App\Categories::find($id)->delete();
        //$categories->delete();
        return redirect('admin-categories')->with('success','App has been deleted');
    }
}
