<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller as Controller;

use App\Suggestions;
use DB;
use Illuminate\Http\Request;

class SuggestionsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $flagstatus = $request->input('status');
        
        if(is_null($flagstatus))
        {
            $flagstatus = "99";
        }

        //dd($flagstatus);
        $status_list = DB::table('statuses')->whereNull('deleted_at')->pluck("name","id");
            $categories = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        //dd($status_list);
        return view('admin/suggestions.index',compact('status_list','flagstatus','categories'));


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/suggestions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

            if ($request->has('newcomments')) {
                try
                    {
                        DB::table('comments')->insert([
                        'suggestions_id' => $request['suggestions_id'],
                        'message' => $request['formText'],
                        'commentor_name' => $request['xyzzy'],
                        'commentor_email' => $request['zyxxy'],
                        'comments_ip' => $request->ip(),
                        'type' => 1,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s')
                        ]);

                        if(!is_null($request['formemailText']))
                        {
                       
                            $base_url = env('APP_URL');
                            $get_data = DB::table('suggestions')->where('id', '=', $request->suggestions_id)->get();

                            $from = 'Simprosys Infomedia <support@simprosys.com>';
                            $cc = 'Support System <jaydeep@simprosys.net>';
                            $bcc = 'Support System <jaydeep@simprosys.net>';
                            $to = 'Support System'.trim($request['active_suggestor']);
                            $ticketemailtemplates = DB::table('emailtemplates')->where("id", "=", 1)->get();
                            $message_subject = trim($ticketemailtemplates[0]->title);
                            $message_email = trim($ticketemailtemplates[0]->content);

                            $token_array_admin = array(
                            'SUGGESTOR_NAME'  => $get_data[0]->suggestor_name,
                            'SUGGESTOR_TITLE'  => $get_data[0]->suggestion_title,
                            'SUGGESTIONS_ID'  => $request->suggestions_id,
                            'COMMENT_DESCRIPTION' => $request['formemailText'],
                            'VIEW_LINK'=> '<a href="' .$base_url.'suggestions/'.$request->suggestions_id .'/'.$get_data[0]->suggestion_slug.'">View Ticket</a>'
                            );
                            $subject = Helpers::parseTemplate($message_subject,$token_array_admin);
                            $message_email = Helpers::buildTemplate($message_email,'user');
                            $emailContent_admin = Helpers::parseTemplate($message_email,$token_array_admin);
                            $data = array('from' => $from, 'to' => $to, 'cc' => $cc, 'cc' => $cc, 'bcc' => $bcc, 'subject' => $subject, 'message' => $emailContent_admin);

                            Helpers::mail($data);

                        }

                        $suggestions_id = DB::getPdo()->lastInsertId();
                        return redirect('admin-suggestions/'.$request['suggestions_id'].'/#comment'.$suggestions_id);


                    }
                    catch(\Illuminate\Database\QueryException $e)
                    {
                        //return View::make('edit.create')->with('status','<strong>'.$siteName.' Site already exist!</strong>'); 
                    }
            }   

            if ($request->has('newsuggestion')) {
 
            $title_slug = str_slug($request['suggestion_title'], '-');

            DB::table('suggestions')->insert([
            'suggestion_title' => $request['suggestion_title'],
            'suggestion_slug' => $title_slug,
            'suggestion_description' => $request['suggestion_description'],
            'suggestor_name' => $request['suggestor_name'],
            'suggestor_email' => $request['suggestor_email'],
            'suggestor_ip' => $request->ip(),
            'type' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);

            $suggestions_id = DB::getPdo()->lastInsertId();

             DB::table('votes')->insert([
            'suggestions_id' => $suggestions_id,
            'vote_ip' => $request->ip(),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);

            return redirect('admin-suggestions')->with('success','Your suggestion was added and is awaiting moderation.');
            }   

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $suggestions = DB::table('suggestions')
        ->select('suggestions.*','statuses.id as stid','statuses.name','statuses.color as scolor','statuses.tooltips as stooltips','categories.name as cat_name')    
        ->join("statuses","suggestions.status_id","=","statuses.id")
        ->join("categories","suggestions.categories_id","=","categories.id")
        ->where('suggestions.id', $id)
        ->whereNull('suggestions.deleted_at')
        ->first();
       
        $comments_list = DB::table('comments')->where('suggestions_id', $id)->whereNull('deleted_at')->get();
        //dd($comments_list);
        $total_votes = DB::table("votes")->where('suggestions_id', $id)->whereNull('deleted_at')->count();

        $my_votes_active = DB::table('votes')
                        ->where('suggestions_id',$id)
                        ->where('vote_ip',\Request::ip())
                        ->count();

        $statuses = DB::table('statuses')->where('id', '!=' , 1)->whereNull('deleted_at')->orderBy('id', 'desc')->get();
        return view('admin/suggestions.show',compact('suggestions','comments_list','total_votes','my_votes_active','statuses'));
        //return view('admin/suggestions.show');
    }

    public function updateStatus(Request $req)
    {
 
        if(!is_null($req['status_email_note']))
        {
            $base_url = env('APP_URL');
            $get_data = DB::table('suggestions')->where('id', '=', $req->suggestions_id)->get();

                $from = 'Simprosys Infomedia <support@simprosys.com>';
                $cc = 'Support System <jaydeep@simprosys.net>';
                $bcc = 'Support System <jaydeep@simprosys.net>';
                $to = 'Support System'.trim($req['active_suggestor']);
                $ticketemailtemplates = DB::table('emailtemplates')->where("id", "=", 1)->get();
                $message_subject = trim($ticketemailtemplates[0]->title);
                $message_email = trim($ticketemailtemplates[0]->content);
                
                $token_array_admin = array(
                    'SUGGESTOR_NAME'  => $get_data[0]->suggestor_name,
                    'SUGGESTOR_TITLE'  => $get_data[0]->suggestion_title,
                    'SUGGESTIONS_ID'  => $req->suggestions_id,
                    'COMMENT_DESCRIPTION' => $req['status_email_note'],
                    'VIEW_LINK'=> '<a href="' .$base_url.'suggestions/'.$req->suggestions_id .'/'.$get_data[0]->suggestion_slug.'">View Ticket</a>'
                );
                $subject = Helpers::parseTemplate($message_subject,$token_array_admin);
                $message_email = Helpers::buildTemplate($message_email,'user');
                $emailContent_admin = Helpers::parseTemplate($message_email,$token_array_admin);
                $data = array('from' => $from, 'to' => $to, 'cc' => $cc, 'cc' => $cc, 'bcc' => $bcc, 'subject' => $subject, 'message' => $emailContent_admin);
                
                Helpers::mail($data);



        }
        $affected = DB::table('suggestions')->where('id', '=', $req->suggestions_id)->update(array('status_id' => $req->status_id));
        $statuses = DB::table('statuses')->where('id', '=', $req->status_id)->get();
        return response()->json(['color'=>$statuses]);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function destroy(Suggestions $suggestions)
    {
        //
    }
}
