jQuery(document).ready(function () {
    // Enable bootstrap tooltips feature
    jQuery('[data-toggle="tooltip"]').tooltip();
});

function formatInteger(num) {
    return num.toString().replace(/(\d)(?=(\d{3})+$)/g, '$1,');
}

function formatCurrency(totalInCents) {
    var dollars = Math.floor(totalInCents / 100);
    var cents = totalInCents % 100;
    var s = "$" + formatInteger(dollars);
    return s + (cents === 0 ? '' : '.' + (cents < 10 ? '0' + cents : cents));
}

// note: not localized
var statuses = [
    {
        id: 1,
        shortName: 'awaitingapproval',
        shortDescription: 'Awaiting approval',
        longDescription: 'This suggestion will be visible when a moderator approves it.',
        cssClass: 'sLabelAM'
    },
    {
        id: 2,
        'shortName': 'underconsideration',
        shortDescription: 'Under consideration',
        longDescription: 'This suggestion is open for upvotes and comments.',
        cssClass: 'sLabelUC'
    },
    {
        id: 3,
        'shortName': 'planned',
        shortDescription: 'Planned',
        longDescription: 'This suggestion is planned for a future release.',
        cssClass: 'sLabelP'
    },
    {
        id: 4,
        'shortName': 'notplanned',
        shortDescription: 'Not planned',
        longDescription: 'This suggestion is not planned for a future release.',
        cssClass: 'sLabelNP'
    },
    {
        id: 5,
        'shortName': 'done',
        shortDescription: 'Done',
        longDescription: 'The suggestion is implemented and released.',
        cssClass: 'sLabelR'
    },
    {
        id: 6,
        'shortName': 'deleted',
        shortDescription: 'Deleted',
        longDescription: 'Only visible to moderators.',
        cssClass: 'sLabelX'
    }
];

function getStatusById(statusId) {
    for (var i = 0; i < statuses.length; i++) {
        var status = statuses[i];
        if (status.id === statusId) {
            return status;
        }
    }
    return null;
}

function merge_formatForMergeDialog(suggestion, radioDiv) {
    var selectable = radioDiv !== null;
    var status = getStatusById(suggestion.suggestionStatusId);
    var dateCreated = suggestion.dateCreated;
    var dateCreatedShort = dateCreated.substring(0, 10);
    var titleDiv = $('<h2 class="modal-sTitle">');
    var titleLink = $('<a target="_blank">').attr('href', suggestion.suggestionPath).text(suggestion.title);
    titleDiv.append(titleLink);
    titleDiv.append('<span class="modal-sID">#' + suggestion.suggestionId + '</span> ');
    var statusDiv1 = $('<div class="modal-sDate">Suggested <strong>' + dateCreatedShort + '</strong> by <strong>' + suggestion.suggestorName + '</strong>');
    var statusDiv2 = $('<div><span class="label ' + status.cssClass + '">' + status.shortDescription + '</span> <small>' + suggestion.voteCount + ' upvotes, ' + suggestion.commentCount + ' comments</small><div>');

    var div = $('<div class="modal-suggestion clearfix">');
    if (selectable) {
        var inner = $('<div class="modal-selectable">');
        inner.append(titleDiv)
            .append(statusDiv1)
            .append(statusDiv2);
        return div
            .append(radioDiv)
            .append(inner);

    } else {
        div.append(titleDiv)
            .append(statusDiv1)
            .append(statusDiv2);
        return div;
    }
}

function merge_setSourceSuggestion(suggestion) {
    var $modalMergeDiv = $('#modalMerge');
    $modalMergeDiv.find('#fromSuggestionContainer').html(merge_formatForMergeDialog(suggestion, null));
    $modalMergeDiv.find('#fromSuggestionId').val(suggestion.suggestionId);
    $modalMergeDiv.find('#merge-search-input').val('');
    $modalMergeDiv.find('#searchResultsContainer').empty();
    $modalMergeDiv.find('#mergeFormSubmit').prop('disabled', true);
}

function merge_setOrigin(origin) {
    $('#modalMerge').find('#origin').val(origin);
}

function merge_doSearchAjaxRequest(query) {
    $.ajax({
        url: '/api/suggestions/fulltextsearch/' + encodeURIComponent(query),
        success: function (matchingSuggestions) {
            // result is an array of "public suggestion" objects
            var $modalMerge = $('#modalMerge');
            var resultsContainer = $modalMerge.find('#searchResultsContainer');
            resultsContainer.empty();

            var fromSuggestionId = $modalMerge.find('#fromSuggestionId').val() - 0;
            // make sure we don't offer the "from" suggestion as a "to" option
            var filteredSuggestions = matchingSuggestions.filter(function (suggestion) {
                return suggestion.suggestionId !== fromSuggestionId;
            });
            if (filteredSuggestions.length === 0) {
                resultsContainer.append('No suggestions matched your search');
            }
            $modalMerge.find('#mergeFormSubmit').prop('disabled', true);
            for (var i = 0; i < filteredSuggestions.length; i++) {
                var candidateTargetSuggestion = filteredSuggestions[i];
                var radioDiv = $('<div class="modal-select">');
                var radioElement = $('<input type=radio name="targetSuggestionId" value="' + candidateTargetSuggestion.suggestionId + '">');
                radioDiv.append(radioElement);
                var div = merge_formatForMergeDialog(candidateTargetSuggestion, radioDiv);
                radioElement.change(merge_wireRadioButtonToForm);
                resultsContainer.append(div);
            }

        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.log('ajax error');
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
}

function merge_wireRadioButtonToForm() {
    var fromSuggestionId = $('#modalMerge').find('#fromSuggestionId').val();
    var targetSuggestionId = $(this).val();
    var action = '/suggestions/' + fromSuggestionId + '/merge/' + targetSuggestionId;
    $('#mergeForm').prop('action', action);
    $('#mergeFormSubmit').prop('disabled', false);
}

function merge_init() {
    var $modalMerge = $('#modalMerge');
    $modalMerge.find('#merge-search-input').on('input', function () {
        var query = $(this).val();
        if (query.length <= 0) {
            var resultsContainer = $('#searchResultsContainer');
            resultsContainer.empty();
            $modalMerge.find('#mergeFormSubmit').prop('disabled', true);
        } else {
            merge_doSearchAjaxRequest(query);
        }
    });
    $modalMerge.on('shown.bs.modal', function () {
        $('#modalMerge').find('#merge-search-input').focus()
    })
}

function split_setSourceSuggestion(suggestion) {
    var $modalSplitDiv = $('#modalSplit');
    $modalSplitDiv.find('#fromTitle').val(suggestion.title);
    $modalSplitDiv.find('#fromDescription').val(suggestion.description);
    $modalSplitDiv.find('#fromSuggestionId').val(suggestion.suggestionId);
    $modalSplitDiv.find('#fromStatusId').val(suggestion.suggestionStatusId);
    $modalSplitDiv.find('#toTitle').val(suggestion.title);
    $modalSplitDiv.find('#toDescription').val(suggestion.description);
    $modalSplitDiv.find('#toStatusId').val(suggestion.suggestionStatusId);
    var action = '/suggestions/' + suggestion.suggestionId + '/split';
    $modalSplitDiv.find('#splitForm').prop('action', action);
    $modalSplitDiv.find('#splitFormSubmit').prop('disabled', true);
}

function split_setOrigin(origin) {
    $('#modalSplit').find('#origin').val(origin);
}

function split_init() {
    var $modalSplit = $('#modalSplit');
    $modalSplit.find('#fromTitle, #toTitle').on('input', function() {
        var fromTitle = $modalSplit.find('#fromTitle').val();
        var toTitle = $modalSplit.find('#toTitle').val();
        var submitDisabled = (fromTitle === toTitle);
        $modalSplit.find('#splitFormSubmit').prop('disabled', submitDisabled);
    });

    $modalSplit.on('shown.bs.modal', function () {
        $modalSplit.find('#fromTitle').focus()
    })
}