@extends('layouts.admin')
@section('title', 'Edit App')
@section('content')

            <div class="page-bx">
                <div class="row">
                   <div class="col-md-12">
                    <h3><i class="fa fa-add"></i> Create New App</h3>
                    <form method="POST" action="{{ route('admin-categories.store') }}" accept-charset="UTF-8" id="formapp">
                    @csrf
                        <div class="form-group">
                            <label>Name:</label>
                            <input class="form-control" name="name" type="text" id="name" placeholder="App Name">
                            @if ($errors->has('name'))
                                <span class="text-danger">{{ $errors->first('name') }}</span>
                            @endif   
                        </div>
                        <div class="form-group">
                            <label>Short Name:</label>
                            <input class="form-control" name="shortname" type="text" id="shortname" placeholder="App Short Name">
                            @if ($errors->has('shortname'))
                                <span class="text-danger">{{ $errors->first('shortname') }}</span>
                            @endif
                            <input type="hidden" name="ischeck" value="1" id="ischeck">
                        </div>
                         <div class="form-group">
                            <label>App Prefix:</label>
                            <input class="form-control" name="shop_prefix" type="text" id="shop_prefix" placeholder="App Prefix">
                            @if ($errors->has('shop_prefix'))
                                <span class="text-danger">{{ $errors->first('shop_prefix') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>App Url:</label>
                            <input class="form-control" name="app_url" type="text" id="app_url" placeholder="App Url">
                            @if ($errors->has('app_url'))
                                <span class="text-danger">{{ $errors->first('app_url') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>Help Doc Url:</label>
                            <input class="form-control" name="help_doc_url" type="text" id="help_doc_url" placeholder="Help Doc Url">
                            @if ($errors->has('help_doc_url'))
                                <span class="text-danger">{{ $errors->first('help_doc_url') }}</span>
                            @endif
                        </div>
                        <div class="form-group">                            
                            <button class="btn" type="submit">Save</button>
                            <a href="{{ url('admin-categories') }}" class="btn btn-default">Back</a>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
@endsection

@section('scripts')           
<script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
    <script type="text/javascript">
    $(document).ready(function() {

        $("#formapp").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 10
                },
                shortname: {
                    required: true
                },
                shop_prefix: {
                    required: true
                },
                app_url: {
                    required: true
                },
                help_doc_url: {
                    required:true
                }
            },
            messages: {
                shortname:{
                    required: "App Short Name is required"
                },
                shop_prefix:{
                    required: "App Prefix is required"
                },
                app_url:{
                    required: "App Url is required"
                },
                help_doc_url:{
                    required: "Help Doc URL is required"
                },
                name: {
                required: "App Name is required"
                }
            },
            errorPlacement: function(error, element) {
                    error.insertAfter(element);
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });
    </script>
@stop
