@extends('layouts.admin')
@section('title', 'Edit App')
@section('content')

            <div class="page-bx">
                <div class="row">
                   <div class="col-md-12">
                    <h3><i class="fa fa-edit"></i> Edit App : {{ $categories->name }}</h3>
                   <form method="POST" action="{{ route('admin-categories.update',$categories->id) }}" accept-charset="UTF-8">
                    @csrf
                    @method('PUT')
                        <div class="form-group">
                            <label>Name:</label>
                            <input class="form-control" name="name" type="text" id="name" value="{{ $categories->name }}" placeholder="App Name">
                            @if ($errors->has('name'))
                                <span class="text-danger">{{ $errors->first('name') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>Short Name:</label>
                            <input class="form-control" name="shortname" type="text" id="shortname" value="{{ $categories->shortname }}" placeholder="App Short Name">
                            @if ($errors->has('shortname'))
                                <span class="text-danger">{{ $errors->first('shortname') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>App Prefix:</label>
                            <input class="form-control" name="shop_prefix" type="text" id="shop_prefix" value="{{ $categories->shop_prefix }}" placeholder="App Prefix">
                            @if ($errors->has('shop_prefix'))
                                <span class="text-danger">{{ $errors->first('shop_prefix') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>App Url:</label>
                            <input class="form-control" name="app_url" type="text" id="app_url" value="{{ $categories->app_url }}" placeholder="App Url">
                            @if ($errors->has('app_url'))
                                <span class="text-danger">{{ $errors->first('app_url') }}</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>Help Doc Url:</label>
                            <input class="form-control" name="help_doc_url" type="text" id="help_doc_url" value="{{ $categories->help_doc_url }}" placeholder="Help Doc Url">
                            @if ($errors->has('help_doc_url'))
                                <span class="text-danger">{{ $errors->first('help_doc_url') }}</span>
                            @endif
                        </div>
                        <div class="form-group">                            
                            <button class="btn" type="submit">Update</button>
                            <a href="{{ url('admin-categories') }}" class="btn btn-default">Back</a>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
@endsection