@extends('layouts.admin')
@section('title', 'Edit Role')
@section('content')
<link href="{{ asset('css/select2.min.css') }}" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('admin-roles.update',$roles->id) }}" accept-charset="UTF-8" class="form-horizontal">
            @csrf
            @method('PUT')
            <h3>Edit Role : {{ $roles->name }}</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="{{ $roles->name }}" placeholder="App Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Color:</label>
                <input id="simple-color-picker" type="text" name="color" class="form-control" value="{{ $roles->color }}"/>
            </div>
            <div class="form-group">
                <label>Permission:</label>
                <select name="permission_ids[]" class="select2 form-control" multiple="multiple">
                    @foreach ($permissionlists as $cat => $value)
                        <option value="{{ $cat }}" @if (str_contains($roles->permission_ids, $cat)) selected @endif> {{ $value }}</option>
                    @endforeach
                </select>
                @if($roles->default_set == 1)
                    <input type="hidden" name="default_set" value="1">
                @else
                    <input type="hidden" name="default_set" value="0">
                @endif
            </div>
            <div class="form-group">
                <div class="check-bx">
                    <label>
                        <input type="checkbox" name="default_set" value="1" id="ischeck" @if($roles->default_set == 1) checked disabled @endif>
                        <span></span>
                        Default Role
                    </label>
                </div>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('admin-roles') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection


@section('scripts')
<script type="text/javascript" src="{{ asset('admin/js/select2.full.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('admin/js/select2.min.js') }}"></script>
<script>

$('#simple-color-picker').minicolors({
    control: $(this).attr('data-control') || 'hue',
    position: $(this).attr('data-position') || 'bottom left',

    change: function(value, opacity) {
        if (!value) return;
        if (opacity) value += ', ' + opacity;
        if (typeof console === 'object') {
            console.log(value);
        }
    },
    theme: 'bootstrap'
});

$(".select2").select2();
</script>
@stop