@extends('layouts.admin')
@section('title', 'Dashboard')

@section('content')
                <div class="row">
                @if ($message = Session::get('success'))
                    <div class="alert alert-success">
                        <p>{{ $message }}</p>
                    </div>
                @endif
                @if ($message = Session::get('errors'))
                    <div class="alert alert-danger">
                        <p>{{ $message }}</p>
                    </div>
                @endif

                        <h2>Suggestions
                            <a href="{{ route('admin-suggestions.create') }}" class="btn pull-right"><i class="icon-plus"></i> Add suggestion</a>
                        </h2>
                </div>
<div class="table-bx">
        <div class="filter-bx">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="customstatusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Status</option>
                            @foreach ($status_list as $cat => $value)
                                <option value="{{ $cat }}"> {{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="statusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Apps</option>
                            @foreach ($categories as $cat => $value)
                                <option value="{{ $cat }}"> {{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <table id="table_suggestions" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </tfoot>
        </table>
    </div>


        

@endsection

@section('scripts')
<script>
var flagstatus = '{{$flagstatus}}';
        $(function() {
           var dtListSuggestion = $('#table_suggestions').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'suggestions']) }}'+ '&flagstatus=' + flagstatus,
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'suggestion_title', name: 'suggestion_title' },
                    { data: 'suggestor_name', name: 'suggestor_name' },
                    { data: 'suggestor_email', name: 'suggestor_email' },
                    { data: 'totalvotes', name: 'totalvotes' },
                    { data: 'suggestor_ip', name: 'suggestor_ip' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });

            $("select[name='search_group_filter']").on( 'change', function (event) {
                    event.preventDefault();
                    var appFilter = $("#statusFilter option:selected").val();
                     var customstatusFilter = $("#customstatusFilter option:selected").val();
                    //alert(customstatusFilter + " - " + appFilter);
                    
                    if(appFilter != 0 && customstatusFilter != 0)
                    {
                            var new_url = '{{ url('loaddata') }}?action=subsuggestion&status=' + appFilter + '&pstatus=' + customstatusFilter;
                            dtListSuggestion.ajax.url(new_url).load();
                    }
                    else if(appFilter != 0)
                    {

                            var new_url = '{{ url('loaddata') }}?action=subsuggestion&status=' + appFilter;
                            dtListSuggestion.ajax.url(new_url).load();
                    }
                    else if(customstatusFilter != 0)
                    {
                        var new_url = '{{ url('loaddata') }}?action=subsuggestion&pstatus=' + customstatusFilter;
                        dtListSuggestion.ajax.url(new_url).load();
                    }
                    else
                    {
                        var new_url = '{{ url('loaddata') }}?action=subsuggestion&status=' + 0 + '&pstatus=' + 0;
                        dtListSuggestion.ajax.url(new_url).load();
                    }
                } );

        });
</script>
@stop