@extends('layouts.admin')
@section('title', 'Edit User')
@section('content')
<link href="{{ asset('admin/css/select2.min.css') }}" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('admin-users.update',$users->id) }}" accept-charset="UTF-8">
            @csrf
            @method('PUT')
            <h3>Edit User : {{ $users->name }}</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="{{ $users->name }}" required placeholder="User Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif 
            </div>
            <div class="form-group">
                <label>Email:</label>
                <input class="form-control" name="email" type="text" id="email" value="{{ $users->email }}" required placeholder="User Email">
                @if ($errors->has('email'))
                    <span class="text-danger">{{ $errors->first('email') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Password:</label>
                <input class="form-control" id="password" type="password" name="password" value="{{ $users->password }}" required placeholder="User password">                              
                @if ($errors->has('password'))
                    <span class="text-danger">{{ $errors->first('password') }}</span>
                @endif  
            </div>
            <div class="form-group">
                <label>Role:</label>
                <select name="role_id" class="form-control" required>
                    <option value="">Select Role</option>
                    @foreach ($roles as $role => $value)
                        <option value="{{ $role }}" @if($role == $users->role_id) selected @endif> {{ $value }}</option>
                    @endforeach
                </select>
                @if ($errors->has('role_id'))
                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                @endif
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('admin-users') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script type="text/javascript" src="{{ asset('admin/js/select2.full.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('admin/js/select2.min.js') }}"></script>
<script>
$(".select2").select2();
</script>
@stop