@extends('layouts.default')
@section('content')

    <h1 class="siteTitle">Suggest an improvement for Feedback System</h1>
    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-8">

            <form class="panel newSuggestion" action="{{ route('suggestions.store') }}" method="post" name="suggestionForm">
              @csrf
                <div class="form-group ">
                    <label class="control-label" for="suggestion_title">Choose App</label>
                    <select class="form-control" name="suggestion_app" id="suggestion_app" required="" autofocus="">
              
                     <option value="">--- Select App's ---</option>
                    @foreach ($categories as $key => $value)
                        <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach
                    </select>
                </div>
                <div class="form-group ">
                    <label class="control-label" for="suggestion_title">Title</label>
                    <input type="text" class="form-control" name="suggestion_title" id="suggestion_title" value="" placeholder="Your suggestion" required="" pattern=".{10,100}" maxlength="100" title="Title must be between 10 and 100 characters.">
                    <p class="help-block notChanging text-right counterContainer"><span id="titleCounter" class="counter invalid">0</span>
                        / 100</p>

                </div>

                <div class="similarSuggestions" id="similarSuggestions" style="display: none">
                    <h3>Is your suggestion already posted?</h3>
                    <ul>
                        <li><span class="label sLabelR">Done</span> <a href="./view.html">
                            <mark>Translate</mark>
                            into Swahili</a></li>
                        <li><a href="./view.html">Lorem
                            <mark>ipsum</mark>
                            dolor sit amet</a></li>
                        <li><a href="./view.html"><span class="label sLabelNP">Not Planned</span>
                            <mark>Translate</mark>
                            into German</a></li>
                        <li><a href="./view.html">Lorem
                            <mark>ipsum</mark>
                            dolor sit amet lorem ipsum lorem ipsum lorem ipsum dolor dolor dolor ipsum lorem lorem.</a>
                        </li>
                        <li><a href="./view.html">Something cool</a></li>
                        <li><a href="./view.html">Something rad!!</a></li>
                    </ul>
                </div>

                <div class="form-group">
                    <label for="suggestion_description">Description</label>
                    <textarea class="form-control" rows="3" name="suggestion_description" id="suggestion_description" required="" placeholder="Description of your suggestion (optional)" maxlength="1000"></textarea>
                    <p class="help-block notChanging text-right counterContainer"><span id="descriptionCounter" class="counter">0</span> / 1000
                    </p>
                </div>

                <div class="form-group">
                    <div>
                        <!--<button type="button" class="btn btn-xs btn-default" id="btnAddImage">Add image (optional)</button>-->
                        <div id="divImagePreview" class="collapse">
                            <span><a href="" target="_blank" id="imagePreviewLink"><img src="" id="imageThumbnail"></a></span>
                            <a href="#" id="removeImage"><span class="glyphicon glyphicon-remove" aria-hidden="true" title="Remove"></span></a>
                        </div>
                    </div>
                    <input type="hidden" name="imagePublicId" id="imagePublicId" value="">
                    <input type="hidden" name="imageFormat" id="imageFormat" value="">
                </div>

                <div class="form-group ">
                    <label class="control-label" for="suggestor_name">Name</label>
                    <input type="text" class="form-control" name="suggestor_name" id="suggestor_name" value="" required="" placeholder="Your name" maxlength="50">
                </div>

                <div class="form-group ">
                    <label class="control-label" for="suggestor_email">Email</label>
                    <input type="email" class="form-control" name="suggestor_email" id="suggestor_email" value="" required="" placeholder="Your email" maxlength="100" autocomplete="email">
                </div>
                <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_SITE_KEY') }}" data-callback="correctCaptcha"></div>
                        @if ($errors->has('g-recaptcha-response'))
                            <span class="invalid-feedback error" style="display: block;">
                                {{ $errors->first('g-recaptcha-response') }}
                            </span>
                        @endif
                    <p class="help-block notChanging">* Email wont be displayed on screen <a href="#" data-toggle="modal" data-target="#modalPrivacyPolicy">Privacy Policy</a>
                    </p>
                </div>
                <div>
                    <input type="submit" class="btn btn-primary submitbtn" value="Post Suggestion" disabled="">
                    <a class="btn btn-default" href="javascript:history.back()" role="button">Cancel</a>
                </div>
            </form>
        </div>
    </div>

<div class="modal fade" id="modalPrivacyPolicy" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Privacy Policy</h4>
            </div>
            <div class="modal-body">
                <p>When submitting your email with a suggestion, heres our policy on what we do with the email.</p>
                <p>We use your email to</p>
                <ul>
                    <li>optionally notify you when your suggestion receives comments</li>
                    <li>optionally notify you when your suggestion receives upvotes</li>
                    <li>optionally notify you when your suggestion is implemented</li>
                    <li>help us analyze suggestions and upvotes</li>
                </ul>
                <p>Your email is never displayed to other users. Judge.me staff will be able to see your email address.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
  
@stop
@section('head')
    <script src='https://www.google.com/recaptcha/api.js'></script>
@endsection
@section('scripts')
<script type="text/javascript" src="{{URL::asset('js/jquery.are-you-sure.js')}}"></script>
<script type="text/javascript" src="{{URL::asset('js/all.js')}}"></script>
<script type="text/javascript">
    var correctCaptcha = function(response) {
        //$(".submitbtn").show();
        $('.submitbtn').prop('disabled', false);
    };
    var msie = document.documentMode;
    if (msie < 9) {
        // code for IE < 9
        window.location.href = '/browsernotsupported'
    }

    var imageCdn = 'https://res.cloudinary.com/featureupvote/image/upload/f_auto/';
    var thumbnailCdn = 'https://res.cloudinary.com/featureupvote/image/upload/c_limit,h_200,w_200,f_auto/';

    function openUploadImageDialog() {
        var hostUrl = location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : '');
        cloudinary.openUploadWidget({
                    cloud_name: 'featureupvote',
                    upload_preset: 'vqkbjmkc',
                    sources: ['local', 'url'],
                    multiple: false,
                    resource_type: 'image',
                    client_allowed_formats: ['png', 'gif', 'jpeg', 'pdf'],
                    tags: 'pr_xw4Ve89K6IyQzgb',
                    text: {
  "sources.url.upload": "Upload",
  "sources.local.drop_file": "Drop file here",
  "progress.use_succeeded": "OK",
  "sources.url.error": "Please type a valid HTTP URL.",
  "sources.url.title": "Web Address",
  "sources.url.note": "Public URL of an image file",
  "sources.local.title": "My files",
  "progress.uploading": "Uploading...",
  "progress.processing": "Processing...",
  "progress.retry_upload": "Try again",
  "sources.local.select_file": "Select File",
  "progress.failed_note": "Some of your images failed uploading.",
  "sources.local.drop_or": "Or"
},
                    stylesheet: hostUrl + '/css/cloudinary.css'
                },
                function (error, result) {
                    if (error !== null) {
                        console.log('failed to upload image');
                        console.log(error);
                        return;
                    }
                    if (result.length > 0) {
                        var firstUpload = result[0];
                        addImage(firstUpload);
                    }
                });

        return false;
    }

    function addImage(image) {
        var imagePublicId = image.public_id;
        var format = image.format;
        var url = imageCdn + imagePublicId + '.' + format;
        var thumbnailFormat = format === 'pdf' ? 'png' : format;
        var thumbnail = thumbnailCdn + imagePublicId + '.' + thumbnailFormat;
        $('#imagePublicId').val(imagePublicId);
        $('#imageFormat').val(format);
        $('#btnAddImage').hide();
        $('#imagePreviewLink').prop('href', url);
        $('#imageThumbnail').prop('src', thumbnail);
        $('#divImagePreview').show();
    }

    function removeImage() {
        $('#imagePublicId').val('');
        $('#imageFormat').val('');
        $('#btnAddImage').show();
        $('#imagePreviewLink').prop('href', '#');
        $('#imageThumbnail').prop('src', '#');
        $('#divImagePreview').hide();
    }

    $(function () {
        // disable enter key in form except for textarea and submit button
        $(document).on("keypress", ":input:not(textarea):not([type=submit])", function (event) {
            if (event.keyCode === 13) {
                event.preventDefault();
            }
        });

        // warn user before leaving page if form has content
        $('form').areYouSure();

        // prevent double form submission
        var $suggestionForm = $("form#suggestionForm");
        $suggestionForm.submit(function () {
            $suggestionForm.submit(function () {
                return false;
            });
        });


        $('#btnAddImage').click(openUploadImageDialog);
        $('#removeImage').click(removeImage);

        $('#suggestionTitle').on('blur', showSimilarSuggestions);

        $('#suggestionDescription').on('input', updateDescriptionCharacterCount);
        $('#suggestionTitle').on('input', updateTitleCharacterCount);

        $('#suggestionDescription').on('input', updateDescriptionHeight);

        // force initial update on page load
        updateTitleCharacterCount();
        updateDescriptionCharacterCount();
        updateDescriptionHeight();
    });

    function updateDescriptionHeight() {
        var height = $('#suggestionDescription').prop('scrollHeight');
        if (height > 84) {
            jQuery(this).css('height', height);
        }
    }

    function updateTitleCharacterCount() {
        var titleLength = jQuery('#suggestionTitle').val().length;
        var element = jQuery('#titleCounter');
        element.html(titleLength);
        if (titleLength >= 10 && titleLength <= 100) {
            element.removeClass('invalid');
        } else {
            element.addClass('invalid');
        }
    }

    function updateDescriptionCharacterCount() {
        var descriptionLength = jQuery('#suggestionDescription').val().length;
        var element = jQuery('#descriptionCounter');
        element.html(descriptionLength);
        if (descriptionLength <= 1000) {
            element.removeClass('invalid');
        } else {
            element.addClass('invalid');
        }
    }




    $(document).ready(function(){
    $("#suggestion_title").keyup(function(){

        var minChars = 4;
        var query = $(this).val();
        if (query.length < minChars) {
            $('#similarSuggestions').hide();
            return;
        }

        var dataobj = {};
        dataobj.q = $(this).val();
                
        dataobj._token = '{{csrf_token()}}';
        $.ajax(
        {
            type:"POST",
            dataType:"json",
            url:"{{ url('/suggestionsfindmatch') }}",
            cache: false,
            data: dataobj,
            success:function(data)
            {
                showMatchingSuggestions(data);
                    $("#suggesstion-box").show();
            }
        });
    });


    function showMatchingSuggestions(matchingSuggestions) {
        var arrayLength = matchingSuggestions.length;
        console.log(arrayLength);
        var $similarSuggestionsPanel = $('#similarSuggestions');
        if (arrayLength === 0) {
            $similarSuggestionsPanel.hide();
            return;
        }
        $similarSuggestionsPanel.show();

        var $similarSuggestionsList = $similarSuggestionsPanel.find('ul');
        $similarSuggestionsList.empty();
        for (var i = 0; i < arrayLength; i++) {
            var suggestion = matchingSuggestions[i];
            console.log(suggestion);
            var title = $('<a target="_blank">').attr('href', suggestion.id).text(suggestion.suggestion_title);
            var li = $('<li>').append(title);
            $similarSuggestionsList.append(li);
        }
    }

});
    </script>
@stop