@extends('layouts.default')
@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ url('/') }}">All suggestions</a></li>
        <li class="active"><h1 class="singleTitle">{{$suggestions->suggestion_title}}</h1></li>
    </ol>

    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif

    <div class="panel suggestionBody">
        <div class="sNumbers  ">
            <div class="sVotes text-center">
                <span class="sNumber">
                    <span id="upvoteCount"
                          title="{{$total_votes}}">{{$total_votes}}</span>
                    <span class="sLabel">votes</span>
                </span>
            </div>

                    <button id="btnVoteUp" class="{{ $my_votes_active == 0 ? 'btn btn-success btn-block btnVoteUp' : 'btn btn-block btnVoteUp btn-votedup' }}">
                        Upvote
                    </button>



        </div>

        <div class="suggestionDescription">
            <p>{{$suggestions->suggestion_description}}</p>
        </div>



        <div class="sMeta">
        <span class="sBy">
            Suggested by: <strong>{{$suggestions->suggestor_name}}</strong> 
            <time datetime="2018-02-14T12:59:48">({{ \Carbon\Carbon::parse($suggestions->created_at)->format('d M, Y')}})</time>
        </span>

             &bull; 
            <span class="sLastComment">
                Upvoted: {{ \Carbon\Carbon::parse($updated_last_votes[0]->created_at)->format('d M, Y')}}
            </span>

             &bull;
            <a href="{{ route('suggestions.show', $suggestions->id) }}"
               class="sComments"><span
                    class="sLabel">Comments: {{$comments_list->count()}}</span>
            </a>

            <p>
                    <span class="label {{$suggestions->color}}" data-toggle="tooltip" data-placement="bottom"
                          title="This suggestion is open for upvotes and comments.">{{$suggestions->name}}</span>

            </p>
        </div>
        @if($suggestions->stid == 6)
        <div class="sControls">
            <div class="btn-group" role="group">
                    <a class="btn btn-default btn-xs" id="btnEdit" href="{{ route('suggestions.edit', $suggestions->id) }}" role="button">Edit</a>

            </div>
        </div>
        @endif
        </div>

        {{$comments_list}}

         @if(!$comments_list->isEmpty() )
        <div class="panel suggestionComments">
            <h2><span class="glyphicon glyphicon-comment"
                      aria-hidden="true"></span> Comments: {{$comments_list->count()}}
            </h2>
            <ul class="commentList">
                @foreach($comments_list as $comments)
                    <li id="comment{{$comments->id}}" class="commentItem ">
                        <span class="theDate">{{ \Carbon\Carbon::parse($comments->created_at)->format('d M, Y')}}</span>
                        <br/>
                        <span class="theAuthor"><strong>{{$comments->commentor_name}}
                            </strong>
                                @if($comments->type == 1)
                               <span class="label sLabelMod">Admin</span>
                                @endif
                        </span>
                        <p>{{$comments->message}}</p>

                    </li>
                @endforeach   
            </ul>
        </div>
        @endif
    @if($suggestions->stid != 6)
    <form id="cForm" class="panel" action="{{ route('comments.store') }}" method="post">
        @csrf
        <h3>Add a comment</h3>

        <div class="form-group ">
            <label class="control-label" for="formText">Message</label>
            <textarea class="form-control" rows="3" name="formText" id="formText"
                      placeholder="Your comment"
                      maxlength="500" minlength="10" required></textarea>
            <p class="help-block notChanging text-right counterContainer"><span id="counter"
                                                                                class="counter">0</span> / 500</p>
        </div>

        <div class="form-group halfWidth ">
            <label class="control-label" for="xyzzy">Name</label>
            <input type="text" class="form-control" name="xyzzy" id="xyzzy" required
                   placeholder="Your name"
                   maxlength="50" />
        </div>

        <div class="form-group halfWidth ">
            <label class="control-label" for="zyxxy">Email</label>
            <input type="email" class="form-control" name="zyxxy" id="zyxxy" required
                   placeholder="Your email" autocomplete="email"
                   maxlength="100"/>
        </div>
        <div class="form-group">
                    <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_SITE_KEY') }}" data-callback="correctCaptcha"></div>
                    @if ($errors->has('g-recaptcha-response'))
                        <span class="invalid-feedback error" style="display: block;">
                            {{ $errors->first('g-recaptcha-response') }}
                        </span>
                    @endif
                                <p class="help-block notChanging">* Email wont be displayed on screen <a href="#" data-toggle="modal"
                                                                                  data-target="#modalPrivacyPolicy">Privacy Policy</a>
            </p>
        </div>
        <input type='hidden' name='suggestions_id' value="{{$suggestions->id}}">
        <input type='text' name='website' style='display:none'>
        <input type='text' name='email' style='display:none'>
        <input type='text' name='url' style='display:none'>
        <div>
            <input type="submit" class="btn btn-primary submitbtn" value="Post Comment" disabled=""/>
            <a class="btn btn-default" href="javascript:history.back()" role="button">Cancel</a>
        </div>
    </form>
    @endif


<div class="modal fade" id="modalPrivacyPolicy" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Privacy Policy</h4>
            </div>
            <div class="modal-body">
                <p>When submitting your email with a suggestion, heres our policy on what we do with the email.</p>
                <p>We use your email to</p>
                <ul>
                    <li>optionally notify you when your suggestion receives comments</li>
                    <li>optionally notify you when your suggestion receives upvotes</li>
                    <li>optionally notify you when your suggestion is implemented</li>
                    <li>help us analyze suggestions and upvotes</li>
                </ul>
                <p>Your email is never displayed to other users. Judge.me staff will be able to see your email address.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modalCreateTag" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Create new tag</h4>
            </div>

            <form method="post" action="/s/5144/tag">
                <div class="modal-body">
                    <div class="panel panel-info">
                        <div class="panel-body">
                            <div class="form-group">
                                <label for="tagName">Please enter a new tag name:</label>
                                <input type="text" name="tagName" id="tagName" required maxlength="30" minlength="2"
                                       class="form-control" placeholder="e.g. High priority">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                    <button type="submit" class="btn btn-primary">Create new tag</button>
                </div>
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade in" tabindex="-1" role="dialog" id="modalMerge">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Merge suggestions</h4>
            </div>
            <div class="modal-body">
                <div id="fromSuggestionContainer"></div>
                <p><small>* Comments and upvotes from this suggestion will be moved to another suggestion.</small></p>
                <h3><strong>Merge the above suggestion into the following suggestion:</strong></h3>
                <div class="form-group modalSearchForm">
                    <label class="control-label" for="merge-search-input">Search suggestions by title or by id</label>
                    <input type="search" class="form-control" name="modalSearch" id="merge-search-input" value="" placeholder="Search..." autofocus="" >
                </div>

                <div id="searchResultsContainer" class="mergeSearchResultsContainer">
                </div>
            </div>
            <div class="modal-footer">
                <form method="post" action="" id="mergeForm">
                    <div class="form-group">
                        <input type="checkbox" name="convertDescription" id="convertDescription" value="true">
                        <label for="convertDescription">Convert the merged suggestions description into a comment
                        </label>
                    </div>
                    <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                    <input type="hidden" name="origin" id="origin">
                    <input type="hidden" name="fromSuggestionId" id="fromSuggestionId">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="mergeFormSubmit" disabled>Merge Now</button>
                </form>
                <p>You cannot undo changes once theyre done.</p>
            </div>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<div class="modal fade in" tabindex="-1" role="dialog" id="modalSplit">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Split suggestion</h4>
            </div>
            <form method="post" action="" id="splitForm">
                <div class="modal-body">
                    <p>Edit the selected suggestion and create a new one.</p>

                    <h3 class="innerModalTitle">Current suggestion</h3>

                    <div id="fromSuggestionContainer">
                        <div class="form-group">
                            <label for="fromTitle">Title</label>
                            <input type="text" class="form-control" id="fromTitle" name="fromTitle" required
                                       pattern=".{10,100}"
                                       maxlength="100"
                                       title="Title must be between 10 and 100 characters.">
                        </div>
                        <div class="form-group">
                            <label for="fromDescription">Description</label>
                                <textarea class="form-control"
                                          id="fromDescription"
                                          name="fromDescription"
                                          rows="3"
                                          maxlength="1000"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="fromStatusId">Status</label>
                            <select id="fromStatusId" name="fromStatusId" class="form-control">
                                <option value="1">Awaiting approval</option>
                                <option value="2">Under consideration</option>
                                <option value="3">Planned</option>
                                <option value="4">Not planned</option>
                                <option value="5">Done</option>
                                <option value="6">Deleted</option>
                            </select>
                        </div>
                    </div>


                    <h3 class="innerModalTitle">New suggestion</h3>

                    <div id="toSuggestionContainer">
                        <div class="form-group">
                            <label for="toTitle">Title</label>
                            <input type="text" class="form-control" id="toTitle" name="toTitle" required
                                   pattern=".{10,100}"
                                   maxlength="100"
                                   title="Title must be between 10 and 100 characters.">
                        </div>
                        <div class="form-group">
                            <label for="toDescription">Description</label>
                            <textarea class="form-control" id="toDescription" name="toDescription" rows="3"
                                      maxlength="1000"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="toStatusId">Status</label>
                            <select id="toStatusId" name="toStatusId" class="form-control">
                                <option value="1">Awaiting approval</option>
                                <option value="2">Under consideration</option>
                                <option value="3">Planned</option>
                                <option value="4">Not planned</option>
                                <option value="5">Done</option>
                                <option value="6">Deleted</option>
                            </select>
                        </div>
                        <div class="form-group">
                            
                            <input type="checkbox" name="copyUpvotes" class="styledCheckbox" id="copyUpvotes" value="true"> 
                            <label for="copyUpvotes">
                            Copy upvotes from current suggestion
                            </label>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                    <input type="hidden" name="origin" id="origin">
                    <input type="hidden" name="fromSuggestionId" id="fromSuggestionId">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="splitFormSubmit" disabled>Split Now</button>
                    <p>You cannot undo changes once theyre done.</p>
                </div>
            </form>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<div class="modal fade in" tabindex="-1" role="dialog" id="modalViewJiraIssue">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Linked Jira issue</h4>
            </div>
            <div class="modal-body">
                <div id="fromSuggestionContainer">
                    <div id="jiraLinkedIssueLoading">
                        Loading...
                    </div>
                    <div id="jiraLinkedIssueInfo">
                        <div>
                            <label class="control-label">Issue:</label>
                            <div id="jiraLinkedIssueKey"></div>
                        </div>
                        <div>
                            <label class="control-label">Summary:</label>
                            <div id="jiraLinkedSummary"></div>
                        </div>
                        <div>
                            <label class="control-label">Status:</label>
                            <div id="jiraLinkedStatus"></div>
                        </div>
                        <div>
                            <label class="control-label">Created:</label>
                            <div id="jiraLinkedCreated"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <form method="post" action="/suggestions/5144/jiraunlink">
                    <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                    <button type="submit" class="btn btn-primary" id="jiraUnlinkIssue">Unlink issue</button>
                    <a class="btn" href="" target="_blank">View issue
                        in Jira</a>
                </form>

            </div>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade in" tabindex="-1" role="dialog" id="modalLinkJiraIssue">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Link a Jira issue</h4>
            </div>

            <div class="modal-body">
                <div class="btn-group">
                    <a href="#" class="btn btn-default active" id="linkCreateNewJiraIssue">Create new Jira issue</a>
                    <a href="#" class="btn btn-default" id="linkLinkExistingJiraIssue">Link to existing issue</a>
                </div>
            </div>

            <div id="divCreateNewJiraIssue">
                <form method="post" action="/suggestions/5144/jiracreateissue">
                    <div class="modal-body">
                        <div id="fromSuggestionContainer">
                            <div class="form-group">
                                <label for="jiraSummary">Summary:</label>
                                <input id="jiraSummary" name="jiraSummary" type="text" class="form-control"
                                       required
                                       maxlength="254" value="Judge.me for Magento">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                        <button type="submit" class="btn btn-primary" id="jiraUnlinkIssue">Create issue</button>

                    </div>
                </form>
            </div>
            <div id="divLinkJiraIssue">
                <form method="post" action="/suggestions/5144/jiralinkissue">
                    <div class="modal-body">
                        <div id="fromSuggestionContainer">
                            <div class="form-group">
                                <label for="jiraIssueId">Issue ID:</label>
                                <input id="jiraIssueId" name="jiraIssueId" type="text" class="form-control"
                                       required
                                       maxlength="50" placeholder="e.g. XYZ-123">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="csrf_token" value="h93lrsbtu89bd605vllutn9pf2">
                        <button type="submit" class="btn btn-primary" id="jiraLinkIssue">Link issue</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@stop
@section('head')
    <script src='https://www.google.com/recaptcha/api.js'></script>
@endsection
@section('scripts')
<script>
    var correctCaptcha = function(response) {
        //$(".submitbtn").show();
        $('.submitbtn').prop('disabled', false);
    };
    var msie = document.documentMode;
    if (msie < 9) {
        // code for IE < 9
        window.location.href = '/browsernotsupported'
    }

    var suggestion = {
  "suggestionId": 5144,
  "title": "Judge.me for Magento",
  "dateCreated": "2018-02-14T12:59:48",
  "description": "Have to switch to magneto and the review apps are awful. Will miss judge.me",
  "suggestorName": "Brett Teper",
  "suggestionStatusId": 2,
  "voteCount": 11,
  "commentCount": 6,
  "slug": "judgeme-for-magento",
  "suggestionPath": "/suggestions/5144/judgeme-for-magento"
};

    function jira_init() {
        $('#linkCreateNewJiraIssue').on('click', function () {
            $('#divLinkJiraIssue').hide();
            $('#divCreateNewJiraIssue').show();
        });
        $('#linkLinkExistingJiraIssue').on('click', function () {
            $('#divCreateNewJiraIssue').hide();
            $('#divLinkJiraIssue').show();
        });
        $('#divLinkJiraIssue').hide();
        $('#jiraLinkedIssueInfo').hide();

    }

    $(function () {
        // Enable image lightbox script
        $(".suggestionScreenshot a").on("click", function (e) {
            e.preventDefault();
            $('#imagePreview').attr('src', $('.suggestionScreenshot a').attr('href'));
            $('#imageModal').modal('show');
        });

        // prevent double form submission
        var $form = $("form#cForm");
        $form.submit(function () {
            $form.submit(function () {
                return false;
            });
        });

        $('#formText').on('input', updateCommentCharacterCount);

        $('#changeStatusOptions').find('a').on('click', function () {
            var statusId = $(this).attr('data-status-id');
            $('#suggestionStatusId').val(statusId);
            $('#formChangeStatus').submit();
        });

        // force initial update on page load
        updateCommentCharacterCount();


        $('#btnVoteUp').click(toggleUpvote);
        $('#btnMerge').click(prepareMergeDialog);
        $('#btnSplit').click(prepareSplitDialog);
        merge_init();
        split_init();
        jira_init();
        tags_init();
        proxyvote_init();
    });

    function tags_init() {
        var $modalCreateTag = $('#modalCreateTag');
        $modalCreateTag.on('shown.bs.modal', function () {
            $modalCreateTag.find('#tagName').focus()
        })
    }

    function proxyvote_init() {
        var $modal = $('#modalProxyVote');
        $modal.on('shown.bs.modal', function () {
            $modal.find('#principalName').focus()
        });
        $modal.on("keypress", "form", function (event) {
            // suppress attempt to submit form when enter key pressed
            return event.keyCode !== 13;
        });

        $('#principalEmail').on('input', function (event) {
            // enable "notify" checkbox when email address is not blank
            var val = $(this).val();
            var disabled = $.trim(val).length === 0;
            $('#notify').prop("disabled", disabled);
        });
    }

    function prepareMergeDialog() {
        merge_setSourceSuggestion(suggestion);
    }

    function prepareSplitDialog() {
        split_setSourceSuggestion(suggestion);
    }

    var voteCount = {{$total_votes}};

    function toggleUpvote() {
        var isUpvoted = !$(this).hasClass('btn-votedup');

        // increment/decrement upvote count (might not match immediately match server, but that's okay)
        var newVoteCount = voteCount + (isUpvoted ? 1 : -1);

        if (newVoteCount < 0) {
            // vote count is as low as we go...so do nothing more
            return;
        }
        voteCount = newVoteCount;
        var $upvoteCount = $('#upvoteCount');
        if (newVoteCount < 1000) {
            $upvoteCount.text(newVoteCount);
        } else if (newVoteCount === 1000) {
            $upvoteCount.text('1K');
        } else {
            // don't change vote count as displayed to user
        }
        $upvoteCount.attr('title', newVoteCount);

        $.post({
            url: "{{ url('toggleupvote') }}",
            data: { _token: '{{csrf_token()}}',sid:'{{$suggestions->id}}'},
            success: function (result) {
                // nothing to do - although we could update the count with the server's actual count?
            }
        });

        if (isUpvoted) {
            $(this).removeClass('btn-success');
            $(this).addClass('btn-votedup');
            $(this).html('Voted up');
            $('#labelNotify').show();
        } else {
            $(this).removeClass('btn-votedup');
            $(this).addClass('btn-success');
            $(this).html('Upvote');
            $('#labelNotify').hide();
        }
    }

    function updateCommentCharacterCount() {
        var formText = jQuery('#formText');
        if (!formText.length) {
            // unapproved suggestion has no comment form
            return;
        }
        var titleLength = formText.val().length;
        var element = jQuery('#counter');
        element.html(titleLength);
        if (titleLength >= 10 && titleLength <= 500) {
            element.removeClass('invalid');
        } else {
            element.addClass('invalid');
        }
    }

    function scrollToForm() {
        $('html, body').animate({
            scrollTop: $("#cForm").offset().top
        }, 800);
    }

</script>
@stop