<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//For Frontends
Route::get('/', 'SuggestionsController@index');
Route::resource('suggestions','SuggestionsController');
Route::resource('comments','CommentsController');
Route::post('toggleupvote', 'CommentsController@toggleupvote');
Route::get('/suggestionsfind', 'SuggestionsController@searchsuggestions');
Route::post('/suggestionsfindmatch', 'SuggestionsController@searchmatchsuggestions');

//Route::get('suggestions/{id}/{slug?}','SuggestionsController@show');
Route::get('/suggestions/{id}/{slug}', 'SuggestionsController@show');


//For Admin Panel

Route::group(['prefix' => 'admin'], function() {
    Auth::routes();
});
Route::get('/home', 'HomeController@index')->name('home');
Route::resource('admin-suggestions','admin\SuggestionsController');
Route::post ( '/updateStatus', 'admin\SuggestionsController@updateStatus' );
Route::resource('loaddata','LoadDataController');

Route::resource('admin-comments','admin\CommentsController');
Route::resource('admin-email-templates','admin\EmailtemplatesController');
Route::resource('admin-roles','admin\RolesController');
Route::resource('admin-users','admin\UsersController');


Route::resource('admin-categories','admin\CategoriesController');


Route::get('send_test_email', function(){
	Mail::raw('Sending emails with Mailgun and Laravel is easy!', function($message)
	{
		$message->to('jaydeep@simprosys.net');
	});
});