<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>

            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <a href="<?php echo e(url('admin-suggestions?status=0')); ?>" title="All">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <h3>All</h3>
                            <h1><?php echo e($suggestions_all); ?></h1>
                        </div>
                    </div>
                    </a>
                </div>
                <div class="col-lg-3 col-md-6">
                    <a href="<?php echo e(url('admin-suggestions?status=1')); ?>" title="All except done">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <h3>All except done</h3>
                            <h1><?php echo e(isset($all_except_done[0]->count_row) ? $all_except_done[0]->count_row : 0); ?></h1>
                        </div>
                    </div>
                    </a>
                </div>
                <?php $__currentLoopData = $suggestions_total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-6">
                    <a href="<?php echo e(url('admin-suggestions?status=').$statusdata->id); ?>" title="<?php echo e($statusdata->name); ?>">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <h3><?php echo e($statusdata->name); ?></h3>
                            <h1><?php echo e(isset($statusdata->count_row) ? $statusdata->count_row : 0); ?></h1>
                        </div>
                    </div>
                    </a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-6">
                    <a href="<?php echo e(url('/home#table_suggestions_wrapper')); ?>" title="Total Votes">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <h3>Total Votes</h3>
                            <h1><?php echo e($total_votes_count_all); ?></h1>
                        </div>
                    </div>
                    </a>
                </div>

            </div>
            
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <div id="container" style="min-width: 310px; height: 400px; max-width: 600px; margin: 0 auto"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <div id="container1" style="min-width: 300px; height: 400px; margin: 0 auto"></div>
                        </div>
                    </div>
                </div>
            </div>
        <!--For Recent Feature Request & Most Votes Feature Request-->
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <div id="container" style="min-width: 310px; height: 400px; max-width: 600px; margin: 0 auto"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="dash-max-h">
                        <div class="dash-bx">
                            <div id="container1" style="min-width: 300px; height: 400px; margin: 0 auto"></div>
                        </div>
                    </div>
                </div>
            </div>



        <!-- Charts -->
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <div class="dash-max-h">
                        <div class="dash-bx">
                    <div id="chartContainer" style="height: 400px;"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Charts -->



                <div class="table-bx">
        <div class="filter-bx">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="customstatusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Status</option>
                            <?php $__currentLoopData = $status_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="statusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Apps</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <table id="table_suggestions" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Created</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Created</th>
                    <th>Status</th>
                </tr>
            </tfoot>
        </table>
    </div>

        

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script type="text/javascript">



// Build the chart
Highcharts.chart('container', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie',
    },
    exporting: { enabled: false },
    credits: {enabled: false},
    title: {
        text: 'Total <?php echo e(config('app.name')); ?> Summery '
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.y}</b></b>'
    },
  legend: {
        align: 'center',
        itemMarginBottom:7
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: true
            },
            showInLegend: true,
            point: {
                events: {
                    click: function () {
                        location.href = '<?php echo e(url('admin-suggestions?status=')); ?>' +
                            this.options.key;
                    }
                }
            }
        }
    },
    series: [{
        name: 'Suggestions',
        colorByPoint: true,
        data: [{
            name: 'All',
            y: <?php echo e($suggestions_all); ?>,
            sliced: true,
            selected: true,
            key:0
        }, {
            name: 'All except done',
            y: <?php echo e(isset($all_except_done[0]->count_row) ? $all_except_done[0]->count_row : 0); ?>,
            key:1
        }, {
            name: '<?php echo e($suggestions_total[0]->name); ?>',
            y: <?php echo e(isset($suggestions_total[0]->count_row) ? $suggestions_total[0]->count_row : 0); ?>,
            key:6
        }, {
            name: '<?php echo e($suggestions_total[1]->name); ?>',
            y: <?php echo e(isset($suggestions_total[1]->count_row) ? $suggestions_total[1]->count_row : 0); ?>,
            key:5
        }, {
            name: '<?php echo e($suggestions_total[2]->name); ?>',
            y: <?php echo e(isset($suggestions_total[2]->count_row) ? $suggestions_total[2]->count_row : 0); ?>,
            key:2
        }, {
            name: '<?php echo e($suggestions_total[3]->name); ?>',
            y: <?php echo e(isset($suggestions_total[3]->count_row) ? $suggestions_total[3]->count_row : 0); ?>,
            key:3
        },{
            name: '<?php echo e($suggestions_total[4]->name); ?>',
            y: <?php echo e(isset($suggestions_total[4]->count_row) ? $suggestions_total[4]->count_row : 0); ?>,
            key:4
        }]
    }]
});



Highcharts.chart('container1', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Total Votes On ' + formatDate(new Date)
    },
    exporting: { enabled: false },
    credits: {enabled: false},
    xAxis: {
        type: 'datetime',
        labels: {
            rotation: -60,
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            },
            format: '{value:%Y-%b-%e}'
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Votes (totals)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: '<b>{point.y} Votes</b>'
    },
    series: [{
        name: 'Population',
        data: <?php echo e($results_chart_votes); ?>,
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // one decimal
            y: 10, // 10 pixels down from the top
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
});

function formatDate(date) {
  var monthNames = [
    "January", "February", "March",
    "April", "May", "June", "July",
    "August", "September", "October",
    "November", "December"
  ];

  var day = date.getDate();
  var monthIndex = date.getMonth();
  var year = date.getFullYear();

  return monthNames[monthIndex] + ' ' + year;
}


        Highcharts.chart('chartContainer', {
            chart: {
                zoomType: 'x'
            },
            exporting: { enabled: false },
            credits: {enabled: false},
            title: {
                text: 'Total Page Views'
            },
            xAxis: {
                type: 'datetime'
            },
            yAxis: {
                title: {
                    text: 'Total Page Views'
                }
            },
            legend: {
                enabled: false
            },
            plotOptions: {
                area: {
                    fillColor: {
                        linearGradient: {
                            x1: 0,
                            y1: 0,
                            x2: 0,
                            y2: 1
                        },
                        stops: [
                            [0, Highcharts.getOptions().colors[0]],
                            [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                        ]
                    },
                    marker: {
                        radius: 2
                    },
                    lineWidth: 1,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    threshold: null
                }
            },

            series: [{
                type: 'area',
                name: 'Pageviews',
                data: <?php echo e($results_pageviews); ?>

            }]
        });

</script>
<script>
        $(function() {
           var dtListSuggestion = $('#table_suggestions').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('loaddata.index',['action' => 'suggestions'])); ?>',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'suggestion_title', name: 'suggestion_title' },
                    { data: 'suggestor_name', name: 'suggestor_name' },
                    { data: 'suggestor_email', name: 'suggestor_email' },
                    { data: 'totalvotes', name: 'totalvotes' },
                    { data: 'suggestor_ip', name: 'suggestor_ip' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });

            $("select[name='search_group_filter']").on( 'change', function (event) {
                    event.preventDefault();
                    var appFilter = $("#statusFilter option:selected").val();
                     var customstatusFilter = $("#customstatusFilter option:selected").val();
                    //alert(customstatusFilter + " - " + appFilter);
                    
                    if(appFilter != 0 && customstatusFilter != 0)
                    {
                            var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + appFilter + '&pstatus=' + customstatusFilter;
                            dtListSuggestion.ajax.url(new_url).load();
                    }
                    else if(appFilter != 0)
                    {

                            var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + appFilter;
                            dtListSuggestion.ajax.url(new_url).load();
                    }
                    else if(customstatusFilter != 0)
                    {
                        var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&pstatus=' + customstatusFilter;
                        dtListSuggestion.ajax.url(new_url).load();
                    }
                    else
                    {
                        var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + 0 + '&pstatus=' + 0;
                        dtListSuggestion.ajax.url(new_url).load();
                    }
                } );

        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>