<?php $__env->startSection('title', 'Apps'); ?>
<?php $__env->startSection('content'); ?>
                <div class="row">
                <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>
                <?php if($message = Session::get('errors')): ?>
                    <div class="alert alert-danger">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>

                        <h2>App's Management
                            <a href="<?php echo e(route('admin-categories.create')); ?>" class="btn pull-right"><i class="icon-plus"></i> Create new App</a>
                        </h2>
                </div>

                <div class="table-bx">
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Short Name</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Short Name</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function() {
            $('#table_tickets').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('loaddata.index',['action' => 'categories'])); ?>',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'shortname', name: 'shortname' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>