<?php $__env->startSection('title', 'Create User'); ?>
<?php $__env->startSection('content'); ?>
<link href="<?php echo e(asset('admin/css/select2.min.css')); ?>" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="<?php echo e(route('admin-users.store')); ?>" accept-charset="UTF-8" id="formapp">
            <?php echo csrf_field(); ?>
            <h3>Create New User:</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" required placeholder="User Name">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?>  
            </div>
            <div class="form-group">
                <label>Email:</label>
                <input class="form-control" name="email" type="text" id="email" required placeholder="User Email">
                <?php if($errors->has('email')): ?>
                    <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Password:</label>
                <input class="form-control" id="password" type="password" name="password" required value="Support@123" placeholder="User password"> <input type="checkbox" onclick="myFunction()">                              
                <?php if($errors->has('password')): ?>
                <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                <?php endif; ?> 
            </div>
            <div class="form-group">
                <label>Role:</label>
                <select name="role_id" class="form-control" required>
                    <option value="">Select Role</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->id); ?>" <?php if($role->default_set == 1): ?> selected <?php endif; ?>> <?php echo e($role->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('role_id')): ?>
                    <span class="text-danger"><?php echo e($errors->first('role_id')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Save</button>
                <a href="<?php echo e(url('admin-users')); ?>" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('admin/js/select2.full.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('admin/js/select2.min.js')); ?>"></script>
    <script>
function myFunction() {
    var x = document.getElementById("password");
    if (x.type === "password") {
        x.type = "text";
    } else {
        x.type = "password";
    }
}
$(".select2").select2();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>