<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class Helpers extends Controller
{

    public function __construct()
    {

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public static function mail($param)
    {
        $cc_email_address = $bcc_email_address = "";

        $configurations = DB::table('configurations')->whereIn('id', [2,3,4])->get();
       

        $from_email_address = 'Support System <'.trim($configurations[0]->config_val).'>';

        if($configurations[1]->config_val != '')
        {
            $cc_email_address = 'Support System <'.trim($configurations[1]->config_val).'>';
        }
        if($configurations[2]->config_val != '')
        {
            $bcc_email_address = 'Support System <'.trim($configurations[2]->config_val).'>';
        }

        $mailgunsecret = env('MAILGUN_SECRET');
        $mailguurl = env('MAILGUN_DOMAIN');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, 'api:'.$mailgunsecret);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_URL, $mailguurl);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            array('from' => $from_email_address,'to' => $param['to'], 'cc' => $cc_email_address, 'bcc' => $bcc_email_address, 'subject' => $param['subject'], 'html' => $param['message']));
        curl_exec($ch);
        curl_close($ch);
    }
    
    public static function parseTemplate($message_email,$token_array)
    {

        $pattern = '[%s]';
        foreach($token_array as $key=>$val){
            $varMap[sprintf($pattern,$key)] = $val;
        }
        return strtr($message_email,$varMap);
    }

    public static function buildTemplate($message_email,$user_type)
    {
        $message_email_data = "<div>";
        if($user_type == 'admin')
        {
            //$message_email_data .="--------admin----------";
            $message_email_data .=$message_email;
        }
        else{
           // $message_email_data .="--------user----------";
            $message_email_data .=$message_email;
        }
        $message_email_data .= "</div>";

        return $message_email_data;

    }

}
