<?php

namespace App\Http\Controllers;

use DB;
use Datatables;
use App\Ticketemailtemplates;
use Illuminate\Http\Request;

class TicketemailtemplatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('ticket-email-templates.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('ticket-email-templates.create'); 
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Ticketemailtemplates::create([
            'title' => $request['title'],
            'content' => $request['content']
        ]);
        return redirect('ticket-email-templates')->with('success','Email Templates created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function show(Ticketemailtemplates $ticketemailtemplates)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ticketemailtemplates = \App\Ticketemailtemplates::find($id);
        return view('ticket-email-templates.edit',compact('ticketemailtemplates','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $ticketemailtemplates= \App\Ticketemailtemplates::find($id);
        $ticketemailtemplates->title=$request->get('title');
        $ticketemailtemplates->content=$request->get('content');
        $ticketemailtemplates->save();

        return redirect('ticket-email-templates')
            ->with('success','Email Template updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
                $ticketemailtemplates = \App\Ticketemailtemplates::find($id)->delete();
        return redirect('ticket-email-templates')->with('success','Email Template has been deleted');
    }
}
