@extends('layouts.default')
@section('title', 'Edit Configuration')
@section('content')

<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('configuration.update',$configuration->id) }}" accept-charset="UTF-8">
            @csrf
            @method('PUT')
            <h3>Edit Configuration : {{ $configuration->name }}</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="{{ $configuration->name }}" placeholder="configuration Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Value:</label>
                <input class="form-control" name="config_val" type="text" id="config_val" value="{{ $configuration->config_val }}" placeholder="configuration Value">
                @if ($errors->has('config_val'))
                    <span class="text-danger">{{ $errors->first('config_val') }}</span>
                @endif
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('configuration') }}" class="btn btn-default">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection