<?php $__env->startSection('title', 'Block Emails'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('errors')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

            <h2>Block Emails Management
            </h2>
    </div>
                <div class="table-bx">
                            <div class="filter-bx">
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="form-group">
                                            <label>Filter By Email</label>
                                            <select id="statusFilter" name="search_group_filter" id="statusFilter" class="form-control">
                                                <option value="bounces"> Bounces</option>
                                                <option value="unsubscribes"> Unsubscribes</option>
                                                <option value="complaints"> Complaints</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>Email</th>
                            <th>Created Date</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>Email</th>
                            <th>Created Date</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function() {
           var dtListSuggestion = $('#table_tickets').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('loaddata.index',['action' => 'blockemails'])); ?>',
                columns: [
                    { data: 'address' },
                    { data: 'created_at'}
                ],
                "aLengthMenu": [[25, 50, 75, 100, 200, 500, 1000], [25, 50, 75, 100, 200, 500, 1000]],
                "aaSorting": [],
                "pageLength": 100,
                "ordering": false,
                "bFilter": false, 
                "bInfo": false
            });

           $('#table_tickets_paginate')[0].style.display = "none";
            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
               var new_url = '<?php echo e(url('loaddata')); ?>?action=blockemails&status=' + filter_value;
                dtListSuggestion.ajax.url(new_url).load();

            } );

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>