<?php $__env->startSection('title', 'Edit App'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit User : <?php echo e($users->name); ?></h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="<?php echo e(route('users.update',$users->id)); ?>" accept-charset="UTF-8" class="form-horizontal">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <fieldset>
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" value="<?php echo e($users->name); ?>" required placeholder="User Name
"><?php if($errors->has('name')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                                <?php endif; ?>                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Email:</label>
                            <div class="controls">
                                <input class="span3" name="email" type="text" id="email" value="<?php echo e($users->email); ?>" required placeholder="User Email
"><?php if($errors->has('email')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Password:</label>
                            <div class="controls">
                                <input class="span3" id="password" type="password" name="password" value="<?php echo e($users->password); ?>" required placeholder="User password
">                              <?php if($errors->has('password')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                                <?php endif; ?>                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Role:</label>
                            <div class="controls">
                                <select name="role_id" class="span3" required>
                                    <option value="">Select Role</option>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($role); ?>" <?php if($role == $users->role_id): ?> selected <?php endif; ?>> <?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('role_id')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('role_id')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Apps:</label>
                            <div class="controls">
                                <select name="category_ids[]" class="span3" required multiple="multiple">
                                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat); ?>" <?php if(str_contains($users->category_ids, $cat)): ?> selected <?php endif; ?>> <?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('role_id')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('role_id')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <br />

                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="<?php echo e(url('users')); ?>" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
    <script>
        $(function() {
        $('.checked_all').on('change', function() {
            $('.checkbox').prop('checked', $(this).prop("checked"));
        });
        //deselect "checked all", if one of the listed checkbox product is unchecked amd select "checked all" if all of the listed checkbox product is checked
        $('.checkbox').change(function(){ //".checkbox" change
            if($('.checkbox:checked').length == $('.checkbox').length){
                $('.checked_all').prop('checked',true);
            }else{
                $('.checked_all').prop('checked',false);
            }
        });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>