<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="span12">
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

            <h2>
                <?php if($status == 1): ?>
                    Active Tickets
                <?php else: ?>
                    Completed Tickets
                <?php endif; ?>
                <a href="<?php echo e(route('tickets.create')); ?>" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Ticket</a>
            </h2>
        <br/>

    <div class="widget-content">
        <table class="table table-condensed table-stripe ddt-responsive" id="table">
            <thead>
            <tr>
                <th>ID</th>
                <th>Subject</th>
                <th>Category</th>
                <th>Priority</th>
                <th>Last Updated</th>
                <th>Status</th>
            </tr>
            </thead>
        </table>
    </div>
    <script>
        var categoryId = <?php echo e($status); ?>;
        $(document).ready(function() {
            $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(url('loaddata')); ?>?action=tickets&catid=' + categoryId,
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'subject', name: 'subject' },
                    { data: 'subname', name: 'subname' },
                    { data: 'pname', name: 'pname' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }
                ],
                "aaSorting": []
            });
        });
    </script>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>