<?php $__env->startSection('title', 'Tickets'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="span12">
            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success">
                    <p><?php echo e($message); ?></p>
                </div>
            <?php endif; ?>
            <h2>
                <?php if($status == 1): ?>
                    Active Tickets
                <?php else: ?>
                    Completed Tickets
                <?php endif; ?>
            </h2>
            <br/>

            <div class="widget-content">
                <table class="table table-condensed table-stripe ddt-responsive" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Ticket</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>App</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <script>
                var categoryId = <?php echo e($status); ?>;
                var flagstatus = <?php echo e($flagstatus); ?>;
                $(function() {
                    var dtListUsers =  $('#table').DataTable({
                        processing: true,
                        serverSide: true,
                        //dom: '<"wrapper"f<"customefilter">lipt>',
                        dom: '<"wrapper"lf<"customefilter"><"customeprioritiyfilter"><t>ip>',
                        ajax: '<?php echo e(url('loaddata')); ?>?action=tickets&catid=' + categoryId + '&flagstatus=' + flagstatus,
                        columns: [
                            { data: 'id', name: 'id' },
                            { data: 'subject', name: 'subject' },
                            { data: 'subname', name: 'subname' },
                            { data: 'pname', name: 'pname' },
                            { data: 'cname', name: 'cname' },
                            { data: 'updated_at', name: 'updated_at' },
                            { data: 'sname', name: 'sname' }
                        ],
                        "aaSorting": [],
                        "pageLength": 25
                    });
                    $('.customefilter').html("<label>Filter By App: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                        "                            <option value=\"0\">Select App</option>\n" +
                        "                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                                <option value=\"<?php echo e($cat); ?>\"> <?php echo e($value); ?></option>\n" +
                        "                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                        </select>");
                    $('.customeprioritiyfilter').html("<label>Filter By Status: </label>    <select name='search_group_filter' id=\"priorityFilter\">\n" +
                        "                            <option value=\"0\">Select Status</option>\n" +
                        "                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stas => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                                <option value=\"<?php echo e($stas); ?>\"> <?php echo e($value); ?></option>\n" +
                        "                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                        </select>");


                    $("select[name='search_group_filter']").on( 'change', function (event) {
                        event.preventDefault();
                        var appFilter = $("#statusFilter option:selected").val();
                         var priorityFilter = $("#priorityFilter option:selected").val();
                        //alert(priorityFilter + " - " + appFilter);
                        
                        if(appFilter != 0 && priorityFilter != 0)
                        {
                                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter + '&pstatus=' + priorityFilter + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                        else if(appFilter != 0)
                        {

                                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                        else if(priorityFilter != 0)
                        {
                            var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&pstatus=' + priorityFilter + '&catid=' + categoryId;
                            dtListUsers.ajax.url(new_url).load();
                        }
                        else
                        {
                                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0 + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                    } );

                });


            </script>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>