<?php include 'header.php';?>
<title>Form Validation using jQuery Validation Plugin <?php echo SITE_NAME; ?></title>
<style type="text/css">
.memberFrm{width: 400px;}
.memberFrm p {
    width: 100%;
}
.memberFrm label {
    width: 120px;
    color: #333;
    float: left;
}
input.error {
    border: 1px dotted red;
}
label.error{
    width: 100%;
    color: red;
    font-style: italic;
    margin-left: 120px;
    margin-bottom: 5px;
}
.memberFrm input.submit {
    margin-left: 120px;
}
</style>
</head>
<body>
<div class="jumbotron text-center" style="margin-bottom:0">
  <h1></h1>
  <p></p>
  <?php include 'example1.php';?> 
</div>

<?php include 'sidebar.php';?>
<div class="col-sm-8">
  <h2></h2>
  <?php include 'example3.php';?>
  <h5></h5>
  <form class="memberFrm" id="memberFrm" method="post" action="">
    <p>
        <label for="name">Name</label>
        <input id="name" name="name" type="text" >
    </p>
    <p>
        <label for="email">E-Mail</label>
        <input id="email" type="email" name="email" >
    </p>
    <p>
        <label for="phone">Phone</label>
        <input id="phone" type="phone" name="phone" >
    </p>
    <p>
        <label for="url">URL</label>
        <input id="url" type="url" name="url">
    </p>
    <p>
        <label for="username">Username</label>
        <input id="username" name="username" type="text">
    </p>
    <p>
        <label for="password">Password</label>
        <input id="password" name="password" type="password">
    </p>
    <p>
        <label for="confirm_password">Confirm password</label>
        <input id="confirm_password" name="confirm_password" type="password">
    </p>
    <p>
        <label for="agree">Please agree to our policy</label>
        <input type="checkbox" class="checkbox" id="agree" name="agree">
    </p>
    <p>
        <input class="submit" type="submit" value="Submit">
    </p>
</form>
  <br>
  <?php include 'example2.php';?>
</div>
    <script type='text/javascript' src='https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js'></script>
<script type="text/javascript">
$(document).ready(function() {
    $("#memberFrm").validate({
        rules: {
            name: "required",
            email: {
                required: true,
                email: true
            },
            phone: {
                required: true,
                number: true
            },
            url: {
                required: false,
                url: true
            },
            username: {
                required: true,
                minlength: 6
            },
            password: {
                required: true,
                minlength: 6
            },
            confirm_password: {
                required: true,
                minlength: 6,
                equalTo: "#password"
            },
            agree: "required"
        },
        messages: {
            name: "Please enter your name",
            email: "Please enter a valid email address",
            phone: {
                required: "Please enter your phone number",
                number: "Please enter only numeric value"
            },
            url: {
                url: "Please enter valid url"
            },
            username: {
                required: "Please enter a username",
                minlength: "Your username must consist of at least 6 characters"
            },
            password: {
                required: "Please provide a password",
                minlength: "Your password must be at least 6 characters long"
            },
            confirm_password: {
                required: "Please provide a password",
                minlength: "Your password must be at least 6 characters long",
                equalTo: "Please enter the same password as above"
            },
            agree: "Please accept our policy"
        }
    });
});
</script>

<?php include 'footer.php';?>

