@extends('layouts.default')
@section('title', 'Edit Canned response')
@section('content')
<link href="{{ asset('css/select2.min.css') }}" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-8">
        <form method="POST" action="{{ route('canned-response.update',$cannedresponses->id) }}" accept-charset="UTF-8" id="formapp">
            @csrf
            @method('PUT')
            <h3>Edit User : {{ $cannedresponses->title }}</h3>
            <div class="form-group">
                <label>Apps:</label>
                <select name="category_ids[]" class="select2 form-control" id="multiple-checkboxes" multiple="multiple">
                    @foreach ($category as $cat => $value)
                        <option value="{{ $cat }}" @if (str_contains($cannedresponses->category_id, $cat)) selected @endif> {{ $value }}</option>
                    @endforeach
                </select>
                  <span class="text-danger apperror"></span>
            </div>
            <div class="form-group">
                <label>Title:</label>
                <input class="form-control" name="title" type="text" id="title" value="{{ $cannedresponses->title }}" placeholder="Canned response Title">
                @if ($errors->has('title'))
                    <span class="text-danger">{{ $errors->first('title') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Description:</label>
                <textarea class="ckeditor" name="content" cols="30" id="content" placeholder="Describe your Canned response here in details">{{ $cannedresponses->content }}</textarea>
                <span class="text-danger contenterror"></span>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('canned-response') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
        <div class="col-md-4">
            <h3>Valid Shortcodes:</h3>
            <div class="form-group">
                        <p>This is a list shortcodes that have been organized by content areas where they can be used:</p>  
                        <h3>To :</h3>
                        <table>
                        <tr><td>[NAME]</td></tr>
                        <tr><td>[EMAIL]</td></tr>
                        <tr><td>[TICKET_NUMBER]</td></tr>
                        <tr><td>[TICKET_SUBJECT]</td></tr>
                        <tr><td>[TICKET_DATE]</td></tr>
                        <tr><td>[TICKET_STATUS]</td></tr>
                        </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script type="text/javascript" src="{{ asset('js/select2.full.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('js/select2.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('ckeditor/ckeditor.js') }}"></script>
    <script>
function myFunction() {
    var x = document.getElementById("password");
    if (x.type === "password") {
        x.type = "text";
    } else {
        x.type = "password";
    }
}
$(".select2").select2();
</script>

<script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
$("#formapp").validate({
    rules: {
        content: {
            required: true,
            minlength: 10
        },
        title: {
            required: true
        },
        "category_ids[]": {
            required: true
        }
    },
    messages: {
        title:{
            required: "Canned response Title is required"
        },
        content: {
        required: "Enter Describe your Canned response here in details",
            minlength: "Minimum password length is 10"
        },
        "category_ids[]":
        {
            required: " App is required"
        }
    },
    errorPlacement: function(error, element) {
        if (element.attr("id") == "content") {
            //element.parent('div').prev().append(error[0]);
            $(".contenterror").append(error[0]);
        } 
        else if(element.attr("id") == "multiple-checkboxes")
        {
            $(".apperror").append(error[0]);
        }
        else {
            error.insertAfter(element);
        }
    },
    submitHandler: function(form) {
        form.submit();
    }
});


CKEDITOR.on('instanceReady', function () {
$.each(CKEDITOR.instances, function (instance) {
    CKEDITOR.instances[instance].document.on("keyup", CK_jQ);
    CKEDITOR.instances[instance].document.on("paste", CK_jQ);
    CKEDITOR.instances[instance].document.on("keypress", CK_jQ);
    CKEDITOR.instances[instance].document.on("blur", CK_jQ);
    CKEDITOR.instances[instance].document.on("change", CK_jQ);
});
});

function CK_jQ() {
for (instance in CKEDITOR.instances) {
    CKEDITOR.instances[instance].updateElement();
}
}

CKEDITOR.config.toolbar = [
    ['Bold','Italic','Underline','StrikeThrough','-','Undo','Redo','-','Cut','Copy','Paste','Find','Replace','-','Outdent','Indent','-','Print']

] ;

});
    </script>
@stop