@extends('layouts.default')
@section('title', 'Configuration')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif

            <h2>Configuration Settings</h2>
    </div>

                <div class="table-bx">
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Value</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Value</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
@endsection
@section('scripts')
    <script>
        $(function() {
            $('#table_tickets').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'configuration']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'config_val', name: 'config_val' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
        });
    </script>
@stop    