@extends('layouts.default')
@section('title', 'Edit Priority')
@section('content')

<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
            <form method="POST" action="{{ route('priorities.update',$priorities->id) }}" accept-charset="UTF-8">
                    @csrf
                    @method('PUT')
            <h3>Edit Priority : {{ $priorities->name }}</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="{{ $priorities->name }}" placeholder="App Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Color:</label>
                <input id="simple-color-picker" type="text" name="color" class="form-control" value="{{ $priorities->color }}"/>
            </div>
            @if($priorities->default_set == 1)
                <input type="hidden" name="default_set" value="1">
            @else
                <input type="hidden" name="default_set" value="0">
            @endif

            <div class="form-group">
                <div class="check-bx">
                    <label>
                        <input type="checkbox" name="default_set" value="1" id="ischeck" @if($priorities->default_set == 1) checked disabled @endif>
                        <span></span>
                        Default Priority
                    </label>
                </div>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('/priorities') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>

$('#simple-color-picker').minicolors({
    control: $(this).attr('data-control') || 'hue',
    position: $(this).attr('data-position') || 'bottom left',

    change: function(value, opacity) {
        if (!value) return;
        if (opacity) value += ', ' + opacity;
        if (typeof console === 'object') {
            console.log(value);
        }
    },
    theme: 'bootstrap'
});
</script>
@stop