@extends('layouts.default')
@section('title', 'Edit Category')
@section('content')

<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('subcategories.update',$subcategories->id) }}" accept-charset="UTF-8">
            @csrf
            @method('PUT')
            <h3>Edit Category : {{ $subcategories->name }}:</h3>
            <div class="form-group">
                <label>App:</label>
                <select name="category_id" class="form-control">
                    <option value="">Select App</option>
                @foreach ($category as $cat => $value)
                        <option value="{{ $cat }}" @if($cat == $subcategories->category_id) selected @endif >{{ $value }}</option>
                @endforeach
                </select>
                @if ($errors->has('category_id'))
                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="{{ $subcategories->name }}" placeholder="Category Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('subcategories') }}" class="btn btn-default">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection