@extends('layouts.default')
@section('title', 'Tickets')

@section('content')


                <div class="row">
                    @if ($message = Session::get('success'))
                        <div class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                    @endif
                    <h2>
                        @if($status == 1)
                            Active Tickets
                        @else
                            Completed Tickets
                        @endif
                    </h2>
                </div>
                <div class="table-bx">
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>App</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>App</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

@endsection

@section('scripts')
<script>
    var categoryId = {{$status}};
    var flagstatus = {{$flagstatus}};
    $(function() {
        var dtListUsers =  $('#table_tickets').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ url('loaddata') }}?action=tickets&catid=' + categoryId + '&flagstatus=' + flagstatus,
            columns: [
                { data: 'id', name: 'id' },
                { data: 'subject', name: 'subject' },
                { data: 'subname', name: 'subname' },
                { data: 'pname', name: 'pname' },
                { data: 'cname', name: 'cname' },
                { data: 'updated_at', name: 'updated_at' },
                { data: 'sname', name: 'sname' }
            ],
            "aaSorting": [],
            "pageLength": 25
        });

        $("select[name='search_group_filter']").on( 'change', function (event) {
            event.preventDefault();
            var appFilter = $("#statusFilter option:selected").val();
             var priorityFilter = $("#priorityFilter option:selected").val();
            //alert(priorityFilter + " - " + appFilter);
            
            if(appFilter != 0 && priorityFilter != 0)
            {
                    var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&pstatus=' + priorityFilter + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
            else if(appFilter != 0)
            {

                    var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
            else if(priorityFilter != 0)
            {
                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&pstatus=' + priorityFilter + '&catid=' + categoryId;
                dtListUsers.ajax.url(new_url).load();
            }
            else
            {
                    var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0 + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
        } );

    });


</script>
@stop