@extends('layouts.default')
@section('title', 'Create User')
@section('content')
<link href="{{ asset('css/select2.min.css') }}" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('users.store') }}" accept-charset="UTF-8" id="formapp">
            @csrf
            <h3>Create New User:</h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" required placeholder="User Name">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif  
            </div>
            <div class="form-group">
                <label>Email:</label>
                <input class="form-control" name="email" type="text" id="email" required placeholder="User Email">
                @if ($errors->has('email'))
                    <span class="text-danger">{{ $errors->first('email') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Password:</label>
                <input class="form-control" id="password" type="password" name="password" required value="Support@123" placeholder="User password"> <input type="checkbox" onclick="myFunction()">                              
                @if ($errors->has('password'))
                <span class="text-danger">{{ $errors->first('password') }}</span>
                @endif 
            </div>
            <div class="form-group">
                <label>Role:</label>
                <select name="role_id" class="form-control" required>
                    <option value="">Select Role</option>
                    @foreach ($roles as $role)
                        <option value="{{ $role->id }}" @if($role->default_set == 1) selected @endif> {{ $role->name }}</option>
                    @endforeach
                </select>
                @if ($errors->has('role_id'))
                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Apps:</label>
                <select name="category_ids[]" class="select2 form-control" required multiple="multiple">
                    @foreach ($category as $cat => $value)
                        <option value="{{ $cat }}"> {{ $value }}</option>
                    @endforeach
                </select>
                @if ($errors->has('role_id'))
                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                @endif
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Save</button>
                <a href="{{ url('users') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript" src="{{ asset('js/select2.full.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('js/select2.min.js') }}"></script>
    <script>
function myFunction() {
    var x = document.getElementById("password");
    if (x.type === "password") {
        x.type = "text";
    } else {
        x.type = "password";
    }
}
$(".select2").select2();
</script>
@stop