<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
});
Route::resource('priorities','PrioritiesController');
Route::resource('categories','CategoriesController');
Route::resource('suggestions','SuggestionsController');
Route::resource('subcategories','SubcategoriesController');
Route::resource('statuses','StatusesController');
Route::resource('tickets','TicketsController');
Route::get('sub_category/get/{id}', 'TicketsController@getSubcategory');
Route::resource('configuration', 'ConfigurationController');
Route::resource('users','UsersController')->middleware('auth','admin');
Route::resource('roles','RolesController');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('createdata', 'TicketsController@createdata');
Route::get('complete', 'TicketsController@complete');
Route::get('/send/email', 'HomeController@mail');

Route::post('ticketcomments', 'TicketsController@ticketcomments');

Route::post ( '/updateStatus', 'TicketsController@update' );
Route::post ( '/updatepriorities', 'TicketsController@updatepriorities' );

Route::get('useractivetickets', 'TicketsController@useractivetickets');
Route::get('usercompletetickets', 'TicketsController@usercompletetickets');

Route::post ( '/updatemultipleimages', 'TicketsController@updatemultipleimages' );

//comman Datatables
Route::resource('loaddata','LoadDataController');

Route::resource('canned-response','CannedresponseController');
Route::resource('ticket-email-templates','TicketemailtemplatesController');
//Send Email
Route::get('mail', 'HomeController@mail');

Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});


Route::resource('suggestiontrackings','SuggestiontrackingsController');

Route::get('notifications', 'HomeController@notifications');

Route::get('/download/{file}', 'HomeController@download');


Route::resource('blockemails','BlockemailsController');