<?php $__env->startSection('title', 'Edit Priority'); ?>
<?php $__env->startSection('content'); ?>

<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
            <form method="POST" action="<?php echo e(route('priorities.update',$priorities->id)); ?>" accept-charset="UTF-8">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
            <h3>Edit Priority : <?php echo e($priorities->name); ?></h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="<?php echo e($priorities->name); ?>" placeholder="App Name">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Color:</label>
                <input id="simple-color-picker" type="text" name="color" class="form-control" value="<?php echo e($priorities->color); ?>"/>
            </div>
            <?php if($priorities->default_set == 1): ?>
                <input type="hidden" name="default_set" value="1">
            <?php else: ?>
                <input type="hidden" name="default_set" value="0">
            <?php endif; ?>

            <div class="form-group">
                <div class="check-bx">
                    <label>
                        <input type="checkbox" name="default_set" value="1" id="ischeck" <?php if($priorities->default_set == 1): ?> checked disabled <?php endif; ?>>
                        <span></span>
                        Default Priority
                    </label>
                </div>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="<?php echo e(url('/priorities')); ?>" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>

$('#simple-color-picker').minicolors({
    control: $(this).attr('data-control') || 'hue',
    position: $(this).attr('data-position') || 'bottom left',

    change: function(value, opacity) {
        if (!value) return;
        if (opacity) value += ', ' + opacity;
        if (typeof console === 'object') {
            console.log(value);
        }
    },
    theme: 'bootstrap'
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>