<?php $__env->startSection('title', 'Tickets'); ?>

<?php $__env->startSection('content'); ?>


                <div class="row">
                    <?php if($message = Session::get('success')): ?>
                        <div class="alert alert-success">
                            <p><?php echo e($message); ?></p>
                        </div>
                    <?php endif; ?>
                    <h2>
                        <?php if($status == 1): ?>
                            Active Tickets
                        <?php else: ?>
                            Completed Tickets
                        <?php endif; ?>
                    </h2>
                </div>
                <div class="table-bx">
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>App</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>App</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var categoryId = <?php echo e($status); ?>;
    var flagstatus = <?php echo e($flagstatus); ?>;
    $(function() {
        var dtListUsers =  $('#table_tickets').DataTable({
            processing: true,
            serverSide: true,
            ajax: '<?php echo e(url('loaddata')); ?>?action=tickets&catid=' + categoryId + '&flagstatus=' + flagstatus,
            columns: [
                { data: 'id', name: 'id' },
                { data: 'subject', name: 'subject' },
                { data: 'subname', name: 'subname' },
                { data: 'pname', name: 'pname' },
                { data: 'cname', name: 'cname' },
                { data: 'updated_at', name: 'updated_at' },
                { data: 'sname', name: 'sname' }
            ],
            "aaSorting": [],
            "pageLength": 25
        });

        $("select[name='search_group_filter']").on( 'change', function (event) {
            event.preventDefault();
            var appFilter = $("#statusFilter option:selected").val();
             var priorityFilter = $("#priorityFilter option:selected").val();
            //alert(priorityFilter + " - " + appFilter);
            
            if(appFilter != 0 && priorityFilter != 0)
            {
                    var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter + '&pstatus=' + priorityFilter + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
            else if(appFilter != 0)
            {

                    var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
            else if(priorityFilter != 0)
            {
                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&pstatus=' + priorityFilter + '&catid=' + categoryId;
                dtListUsers.ajax.url(new_url).load();
            }
            else
            {
                    var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0 + '&catid=' + categoryId;
                    dtListUsers.ajax.url(new_url).load();
            }
        } );

    });


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>