<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="span12">
            <div class="widget widget-nopad">
                <div class="widget-header"> <i class="icon-list-alt"></i>
                    <h3> Support Ticketing System Stats</h3>
                </div>
                <!-- /widget-header -->
                <div class="widget-content">
                    <div class="widget big-stats-container">
                        <div class="widget-content">
                            <div id="big_stats" class="cf">
                                
                                <a href="<?php echo e(url('tickets?status=0')); ?>" class="stat" title="New"><h2>New</h2><span class="value"><i class="icon-file"></i> <?php echo e($newtickets); ?></span> </a>

                                <a href="<?php echo e(url('tickets?status=1')); ?>" class="stat" title="Open"><h2>Open</h2><span class="value"><i class="icon-folder-open"></i> <?php echo e($opentickets); ?></span> </a>

                                <a href="<?php echo e(url('complete')); ?>" class="stat" title="Completed tickets"><h2>Completed tickets</h2><span class="value"><i class="icon-folder-close"></i> <?php echo e($completetickets); ?></span> </a>
                                <!-- .stat -->
                                
                                <a href="<?php echo e(url('tickets')); ?>" class="stat" title="Total tickets"><h2>Total tickets</h2><span class="value"><i class="icon-anchor"></i> <?php echo e($activetickets + $completetickets); ?></span> </a>
                                <!-- .stat -->

                            </div>
                        </div>
                        <!-- /widget-content -->

                    </div>
                </div>
            </div>
            <!-- /widget -->
        </div>
        <!-- /span6 -->
    </div>
    <!-- /row -->
    <div class="row">
        <div class="span12">
            <div class="widget widget-table action-table">
                <div class="widget-header"> <i class="icon-th-list"></i>
                    <h3> Recent Tickets</h3>
                    <select id="statusFilter" name="search_group_filter" class="pull-right" style="margin: 7px;">
                        <option value="0">All Apps</option>
                        <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select id="customstatusFilter" name="search_group_filter" class="pull-right" style="margin: 7px;">
                        <option value="0">All Status</option>
                        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>"> <?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- /widget-header -->
                <div class="widget-content">
                    <table class="table table-striped table-bordered" id="table">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                        </tr>
                        </thead>

                    </table>
                </div>

                <div class="widget-header">
                    <div class="pull-right">
                        <div class="btn-group">
                            <h3><a href="<?php echo e(url('tickets')); ?>">View more</a></h3>
                        </div>
                    </div>
                </div>
                <!-- /widget-content -->
            </div>
        </div>
    </div>
    <script>
        $(function() {
            var dtListtickets = $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0,
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'subject', name: 'subject' },
                    { data: 'subname', name: 'subname' },
                    { data: 'pname', name: 'pname' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }

                ],
                "aaSorting": [],
                "paging":   false,
                "bInfo": false,
                "bFilter": false,
                "ordering": false
            });

                     $("select[name='search_group_filter']").on( 'change', function (event) {
                        event.preventDefault();
                        var appFilter = $("#statusFilter option:selected").val();
                         var customstatusFilter = $("#customstatusFilter option:selected").val();
                        //alert(customstatusFilter + " - " + appFilter);
                        
                        if(appFilter != 0 && customstatusFilter != 0)
                        {
                                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter + '&pstatus=' + customstatusFilter;
                                dtListtickets.ajax.url(new_url).load();
                        }
                        else if(appFilter != 0)
                        {

                                var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + appFilter;
                                dtListtickets.ajax.url(new_url).load();
                        }
                        else if(customstatusFilter != 0)
                        {
                            var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&pstatus=' + customstatusFilter;
                            dtListtickets.ajax.url(new_url).load();
                        }
                        else
                        {
                            var new_url = '<?php echo e(url('loaddata')); ?>?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0;
                            dtListtickets.ajax.url(new_url).load();
                        }
                    } );
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>