<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Support Ticketing System</title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/bootstrap.min.css')); ?>" >
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/bootstrap-responsive.min.css')); ?>" >
    <link href="//fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,400,600"
          rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/font-awesome.css')); ?>" >
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/style.css')); ?>" >
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/signin.css')); ?>" >
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/dashboard.css')); ?>" >
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/custom.css')); ?>" >
    <link  href="//cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css" rel="stylesheet">
    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
    <script src="<?php echo e(asset('js/jquery-1.7.2.min.js')); ?>"></script>

    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('js/excanvas.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/chart.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/bootstrap.js')); ?>"></script>
    <script src="<?php echo e(asset('js/base.js')); ?>"></script>
    <script type="text/javascript">
var APP_URL = <?php echo json_encode(url('/')); ?>

</script>
</head>
<body>
<div class="navbar navbar-fixed-top">
    <div class="navbar-inner">
        <div class="container"> <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse"><span
                        class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span> </a><a class="brand" href="<?php echo e(url('/')); ?>">Support Ticketing System </a>
            <div class="nav-collapse">
                <ul class="nav pull-right">
                    <?php if(auth()->guard()->guest()): ?>
                        <li class="dropdown"><a href="#" data-toggle="dropdown">Domain Name : <?php echo e(env('DOMAIN_NAME')); ?></a>
                        </li>
                        <li><a class="dropdown" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a></li>
                    <?php else: ?>
                        <li class="dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown"><i
                                        class="icon-user"></i> <?php echo e(Auth::user()->name); ?> <b class="caret"></b></a>
                            <ul class="dropdown-menu">
                                <li><a  href="<?php echo e(route('logout')); ?>"
                                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form></li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
            <!--/.nav-collapse -->
        </div>
        <!-- /container -->
    </div>
    <!-- /navbar-inner -->
</div>

<div class="main">
    <div class="main-inner">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- /container -->
    </div>
    <!-- /main-inner -->
</div>
<!-- /main -->

<!-- /extra -->
<div class="footer">
    <div class="footer-inner">
        <div class="container">
            <div class="row">
                <div class="span12"> &copy; 2018 <a href="#">Support Ticketing System</a>. </div>
                <!-- /span12 -->
            </div>
            <!-- /row -->
        </div>
        <!-- /container -->
    </div>
    <!-- /footer-inner -->
</div>
<!-- /footer -->
    <!-- JavaScripts -->
    <script src="https://www.google.com/recaptcha/api.js"></script>

    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/2.2.3/jquery.min.js" integrity="sha384-I6F5OKECLVtK/BL+8iSLDEHowSAfUo76ZL9+kGAgTRdiByINKJaqTPH/QVNS1VDb" crossorigin="anonymous"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.6/js/bootstrap.min.js" integrity="sha384-0mSbJDEHialfmuBBQP6A4Qrprq5OVfW37PRR3j5ELqxss1yVqOtnepnHVP9aJ7xS" crossorigin="anonymous"></script>
    <script src="//cdn.ckeditor.com/ckeditor5/1.0.0-beta.1/classic/ckeditor.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.17.0/jquery.validate.min.js"></script>
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/custom.css')); ?>" >
    <script>
        ClassicEditor
            .create( document.querySelector( '#content' ) )
            .then(editor => {
                document.getElementById('content').innerHTML = editor.getData();

            })
            .catch( error => {
                console.error( error );
            } );

        //Form Validation
        $().ready(function() {
            $("#form").validate({
                ignore: [],
                rules : {
                    subject : {
                        required : true
                    },
                    category_id : {
                        required: true
                    },
                    email : {
                        required: true,
                        email:true
                    }
                },
                messages: {
                    subject: "The subject field is required.",
                    category_id: "The App field is required.",
                    content: "The content field is required.",
                    password: {
                        required: "Enter your password",
                        minlength: "Minimum password length is 5",
                        maxlength: "Maximum password length is 8"
                    },
                    email: "Enter you email"
                },
                submitHandler: function(form) {
                    form.submit();
                }
            });
        });

        var correctCaptcha = function(response) {
            $(".form-actions").show();
            $("#submitbtn").show();
        };


    </script>
</body>
</html>
