<?php $__env->startSection('title', 'Email Templates'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('errors')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

            <h2>Email Templates Management
                <a href="<?php echo e(route('ticket-email-templates.create')); ?>" class="btn pull-right"><i class="icon-plus"></i> Create new Email Templates</a>
            </h2>
    </div>
                <div class="table-bx">
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(function() {
        var dtListUsers = $('#table_tickets').DataTable({
            processing: true,
            serverSide: true,
            ajax: '<?php echo e(route('loaddata.index',['action' => 'emailtemplates'])); ?>',
            columns: [
                { data: 'id', name: 'id' },
                { data: 'title', name: 'title' },
                { data: 'updated_at', name: 'updated_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
            ],
            "aaSorting": [],
            "pageLength": 25
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>