<?php $__env->startSection('title', 'Create Suggestion'); ?>
<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js"></script>
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-plus"></i>
                <h3>Create New Suggestion</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="<?php echo e(route('suggestions.store')); ?>" accept-charset="UTF-8" class="form-horizontal" id="formapp">
                    <fieldset>
                        <?php echo csrf_field(); ?>
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">App:</label>
                            <div class="controls">
                                <select name="category_id" class="span6">
                                    <option value="">Select App</option>
                                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('category_id')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('category_id')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <div class="control-group">
                            <label class="control-label asterisk" for="suggestion">Title:</label>
                            <div class="controls">
                                <input class="span6" name="title" type="text" id="title" placeholder="Suggestion Title
"><?php if($errors->has('title')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('title')); ?></span>
                                <?php endif; ?>                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="destination_url">Destination Url:</label>
                            <div class="controls">
                                <input class="span6" name="destination_url" type="text" id="destination_url" placeholder="Destination Url
"><?php if($errors->has('destination_url')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('destination_url')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="keywords">Keywords:</label>
                            <div class="controls">
                                <input class="span6" data-role="tagsinput" name="keywords" type="text" id="keywords" placeholder="Enter Your keywords
"><?php if($errors->has('keywords')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('keywords')); ?></span>
                                <?php endif; ?>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->



                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Submit">
                            <a href="<?php echo e(url('suggestions')); ?>" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
<script>
    //Form Validation
    $().ready(function() {
        $("#formapp").validate({
            ignore: [],
            rules : {
                title : {
                    required : true,
                    minlength: 10
                },
                destination_url : {
                    required: true
                },
                keywords : {
                    required: true
                },
                category_id : {
                    required: true
                }
            },
            messages: {
                title: {
                    required:"The Title field is required.",
                    minlength: "Your title must be at least 10 characters long"
                },
                destination_url: "The Destination URL is required.",
                keywords: "The keywords field is required.",
                category_id: "The App field is required."
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>