<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\User;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMailable;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('notifications');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $apps = DB::table("tickets")
            ->join('categories', 'tickets.category_id', '=', 'categories.id')
            ->select('tickets.category_id','categories.name', DB::raw('COUNT(tickets.category_id) as totalrow'))
            ->groupBy('tickets.category_id')
           ->get();


        $subcategories = DB::table('tickets')
            ->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id')
            ->select('tickets.sub_category_id','subcategories.name', DB::raw('COUNT(tickets.sub_category_id) as count'))
            ->groupBy('sub_category_id')
            ->get();

        $domain = DB::table('tickets')
            ->select('domain_name', DB::raw('COUNT(tickets.domain_name) as count'))
            ->groupBy('domain_name')->get();

        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        $statuses = DB::table('statuses')->whereNull('deleted_at')->pluck("name","id");
        return view('home',compact('apps','subcategories','domain','category','statuses'));

    }

    public function notifications(Request $request)
    {
       
        try{
                    $notifications = DB::table('notifications')
                    ->where('status', '=', 0)
                    ->whereDate('duration_dates','=',date('Y-m-d'))
                    ->latest()
                    ->first();
                    
                    if(!is_null($notifications))
                    {
                        
                        $last_commnets = DB::table('comments')->where('ticket_id', $notifications->ticket_id)->latest()->first();
                        if($notifications->status_id == 5)
                        {
                            $affected = DB::table('tickets')->where('id', '=', $notifications->ticket_id)->update(array('status_id' => 3));
                            $status_id = 3;
                        }
                        else
                        {
                            $affected = DB::table('tickets')->where('id', '=', $notifications->ticket_id)->update(array('status_id' => 1));
                            $status_id = 1;
                        }

                        DB::table('notifications')->insert([
                            'ticket_id' => $notifications->ticket_id,
                            'user_id' => $notifications->user_id,
                            'status_id' => $status_id,
                            'ip_address' => $request->ip(),
                            'time_durations_id' => 0,
                            'duration_dates' => $notifications->duration_dates,
                            'last_comments_id' => $last_commnets->id,
                            'status' => 1,
                            'created_at' => date('Y-m-d H:i:s'),
                            'updated_at' => date('Y-m-d H:i:s')
                        ]);

                        $affected = DB::table('notifications')
                        ->where('status', '=', 0)
                        ->whereDate('duration_dates','=',date('Y-m-d'))
                        ->update(array('status' => 2));
                    }




        }
        catch(\Exception $e){
            $affected = DB::table('notifications')
            ->where('status', '=', 0)
            ->whereDate('duration_dates','=',date('Y-m-d'))
            ->update(array('status' => 3));
        }
    }

    public function mails()
    {
        $name = 'jaydeep';
        Mail::to('jaydeep@simprosys.net')->send(new SendMailable($name));

        return 'Email was sent';

    }

    public function download($file_name) {
       // $file_path = base_path()('img/atteach/'.$file_name);
        $file_path_full =base_path()."/img/atteach/".$file_name;
        $file_path =pathinfo(base_path()."/img/atteach/".$file_name);

        $basename = $file_path['basename'];
        $path = $file_path['dirname'];
        return response()->download($file_path_full, $basename, ['Content-Type' => 'application/force-download']);
      }

    public function download123($file_name) {
       // $file_path = base_path()('img/atteach/'.$file_name);
        $file_path =env('APP_URL')."img/atteach/".$file_name;
                $headers = ['Content-Type: application/pdf'];
        $name = basename($file_path);
        return response()->download($file_path,$name,$headers);
      }


    public function mail()
    {

        $from = 'Simprosys Infomedia <support@simprosys.com>';
        $to = 'Support System <jaydeep@simprosys.net>';
        $cc = 'Support System <jaydeep@simprosys.net>';
        $bcc = 'Support System <jaydeep@simprosys.net>';
        $subject = 'Support Ticketing System';
        $message = '<b>Support Ticketing System</b> .';

        $data = array('from' => $from, 'to' => $to, 'cc' => $cc, 'cc' => $cc, 'bcc' => $bcc, 'subject' => $subject, 'message' => $message);
        Helpers::mail($data);

    }

}
