@extends('layouts.default')
@section('title', 'Dashboard')

@section('content')
    <div class="row">
        <div class="col-lg-3 col-md-6">
            <a href="{{ url('tickets?status=0') }}" title="New">
            <div class="dash-max-h">
                <div class="dash-bx">
                    <h3>New Tickets</h3>
                    <h2>{{$newtickets}}</h2>
                </div>
            </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6">
            <a href="{{ url('tickets?status=1') }}" title="Open">
            <div class="dash-max-h">
                <div class="dash-bx">
                    <h3>Open Tickets</h3>
                    <h2>{{$opentickets}}</h2>
                </div>
            </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6">
            <a href="{{ url('complete') }}" title="Completed tickets">
            <div class="dash-max-h">
                <div class="dash-bx">
                    <h3>Completed Tickets</h3>
                    <h2>{{$completetickets}}</h2>
                </div>
            </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6">
            <a href="{{ url('tickets') }}" title="Total tickets">
            <div class="dash-max-h">
                <div class="dash-bx">
                    <h3>Total Tickets</h3>
                    <h2>{{$activetickets + $completetickets}}</h2>
                </div>
            </div>
            </a>
        </div>
    </div>

    <div class="table-bx">
        <div class="filter-bx">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="statusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Apps</option>
                            @foreach ($category as $cat => $value)
                                <option value="{{ $cat }}"> {{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Status</label>
                        <select id="customstatusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Status</option>
                            @foreach ($statuses as $status => $value)
                                <option value="{{ $status }}"> {{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Ticket</th>
                    <th>Category</th>
                    <th>Priority</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
                <tr>
                    <th>ID</th>
                    <th>Ticket</th>
                    <th>Category</th>
                    <th>Priority</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </tfoot>
        </table>
    </div>

@endsection

@section('scripts')
<script>
    $(function() {
        var dtListtickets = $('#table_tickets').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0,
            columns: [
                { data: 'id', name: 'id' },
                { data: 'subject', name: 'subject' },
                { data: 'subname', name: 'subname' },
                { data: 'pname', name: 'pname' },
                { data: 'updated_at', name: 'updated_at' },
                { data: 'sname', name: 'sname' }

            ],
            "aaSorting": [],
            "paging":   true,
            "bInfo": true,
            "bFilter": true,
            "ordering": true,
            "pageLength": 25
        });

                 $("select[name='search_group_filter']").on( 'change', function (event) {
                    event.preventDefault();
                    var appFilter = $("#statusFilter option:selected").val();
                     var customstatusFilter = $("#customstatusFilter option:selected").val();
                    //alert(customstatusFilter + " - " + appFilter);
                    
                    if(appFilter != 0 && customstatusFilter != 0)
                    {
                            var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&pstatus=' + customstatusFilter;
                            dtListtickets.ajax.url(new_url).load();
                    }
                    else if(appFilter != 0)
                    {

                            var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter;
                            dtListtickets.ajax.url(new_url).load();
                    }
                    else if(customstatusFilter != 0)
                    {
                        var new_url = '{{ url('loaddata') }}?action=subfiltertickets&pstatus=' + customstatusFilter;
                        dtListtickets.ajax.url(new_url).load();
                    }
                    else
                    {
                        var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0;
                        dtListtickets.ajax.url(new_url).load();
                    }
                } );
    });
</script>
@stop