@extends('tickets.layout')


@section('content')

<!-- @if ($errors->any())
    <div class="alert alert-danger">
        <strong>Whoops!</strong> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif -->

@if ($message = Session::get('success'))
<div class="alert alert-success">
    <p>{{ $message }}</p>
</div>
@endif
<div class="container">
    <div class="well bs-component">
        <form method="POST" action="{{ route('tickets.store') }}" class="form-horizontal" id="form">
            @csrf
            <legend>Create New Ticket</legend>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-2 control-label">Email:</label>
                <div class="col-sm-10">
                    <input type="text" name="email" class="form-control" value="user@gmail.com">
                </div>
            </div>
            <div class="form-group">
                <label for="inputPassword3" class="col-sm-2 control-label">App:</label>
                <div class="col-sm-3">
                    <select name="category_id" class="form-control">
                        <option value="">Select App</option>
                        @foreach ($category as $cat => $value)
                        <option value="{{ $cat }}"> {{ $value }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('category_id'))
                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label for="inputPassword3" class="col-sm-2 control-label">Category:</label>
                <div class="col-sm-3">
                    <select name="sub_category_id" class="form-control">
                        <option>Select Category</option>

                    </select>
                    @if ($errors->has('sub_category_id'))
                    <span class="text-danger">{{ $errors->first('sub_category_id') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-2 control-label">Subject:</label>
                <div class="col-sm-10">
                    <input class="form-control" name="subject" type="text" id="subject" placeholder="A brief of your issue ticket
">		   @if ($errors->has('subject'))
                    <span class="text-danger">{{ $errors->first('subject') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-2 control-label">Description:</label>
                <div class="col-sm-10">
                    <textarea class="form-control" name="content" cols="50" id="content" placeholder="Describe your issue here in details"></textarea>
                    @if ($errors->has('content'))
                    <span class="text-danger">{{ $errors->first('content') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-2 control-label">Priority:</label>
                <div class="col-sm-3">
                    <select name="priority_id" class="form-control">
                        <option value="">Select Priority</option>
                        @foreach ($priority as $prity)
                        <option value="{{$prity->id}}" @if($prity->default_set == 1) selected @endif>{{$prity->name}}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('priority_id'))
                    <span class="text-danger">{{ $errors->first('priority_id') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group{{ $errors->has('g-recaptcha-response') ? ' has-error' : '' }}">
                <div class="col-sm-offset-2 col-sm-10">
                    <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_SITE_KEY') }}" data-callback="correctCaptcha"></div>
                    @if ($errors->has('g-recaptcha-response'))
                    <span class="invalid-feedback" style="display: block;">
                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                    </span>
                    @endif
                </div>
            </div>

            <input type="hidden" name="domain_name" class="form-control" value="{{$domainname}}">
            <input type="hidden" name="ticketable_type" class="form-control" value="0">
            <input type="hidden" name="ticketable_id" class="form-control" value="2">
            <input type="hidden" name="status_id" class="form-control" value="{{$statuses[0]->id}}">

            <div class="form-group">
                <div class="col-sm-offset-2 col-sm-10">
                    <!-- <a href="{{ route('tickets.index') }}" class="btn btn-default">Back</a> -->
                    <input class="btn btn-primary" type="submit" disabled value="Submit" id="submitbtn">
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
