<?php $__env->startSection('title', 'Edit App'); ?>
<?php $__env->startSection('content'); ?>
<link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="<?php echo e(route('users.update',$users->id)); ?>" accept-charset="UTF-8">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <h3>Edit User : <?php echo e($users->name); ?></h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="<?php echo e($users->name); ?>" required placeholder="User Name">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?> 
            </div>
            <div class="form-group">
                <label>Email:</label>
                <input class="form-control" name="email" type="text" id="email" value="<?php echo e($users->email); ?>" required placeholder="User Email">
                <?php if($errors->has('email')): ?>
                    <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Password:</label>
                <input class="form-control" id="password" type="password" name="password" value="<?php echo e($users->password); ?>" required placeholder="User password">                              
                <?php if($errors->has('password')): ?>
                    <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                <?php endif; ?>  
            </div>
            <div class="form-group">
                <label>Role:</label>
                <select name="role_id" class="form-control" required>
                    <option value="">Select Role</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role); ?>" <?php if($role == $users->role_id): ?> selected <?php endif; ?>> <?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('role_id')): ?>
                    <span class="text-danger"><?php echo e($errors->first('role_id')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Apps:</label>
               <select name="category_ids[]" class="select2 form-control" required multiple="multiple">
                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat); ?>" <?php if(str_contains($users->category_ids, $cat)): ?> selected <?php endif; ?>> <?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('role_id')): ?>
                    <span class="text-danger"><?php echo e($errors->first('role_id')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="<?php echo e(url('users')); ?>" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/select2.full.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/select2.min.js')); ?>"></script>
<script>
$(".select2").select2();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>