<?php $__env->startSection('title', 'Edit Role'); ?>
<?php $__env->startSection('content'); ?>
<link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet">
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="<?php echo e(route('roles.update',$roles->id)); ?>" accept-charset="UTF-8" class="form-horizontal">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <h3>Edit Role : <?php echo e($roles->name); ?></h3>
            <div class="form-group">
                <label>Name:</label>
                <input class="form-control" name="name" type="text" id="name" value="<?php echo e($roles->name); ?>" placeholder="App Name">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Color:</label>
                <input id="simple-color-picker" type="text" name="color" class="form-control" value="<?php echo e($roles->color); ?>"/>
            </div>
            <div class="form-group">
                <label>Permission:</label>
                <select name="permission_ids[]" class="select2 form-control" multiple="multiple">
                    <?php $__currentLoopData = $permissionlists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat); ?>" <?php if(str_contains($roles->permission_ids, $cat)): ?> selected <?php endif; ?>> <?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($roles->default_set == 1): ?>
                    <input type="hidden" name="default_set" value="1">
                <?php else: ?>
                    <input type="hidden" name="default_set" value="0">
                <?php endif; ?>
            </div>
            <div class="form-group">
                <div class="check-bx">
                    <label>
                        <input type="checkbox" name="default_set" value="1" id="ischeck" <?php if($roles->default_set == 1): ?> checked disabled <?php endif; ?>>
                        <span></span>
                        Default Role
                    </label>
                </div>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="<?php echo e(url('roles')); ?>" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/select2.full.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/select2.min.js')); ?>"></script>
<script>

$('#simple-color-picker').minicolors({
    control: $(this).attr('data-control') || 'hue',
    position: $(this).attr('data-position') || 'bottom left',

    change: function(value, opacity) {
        if (!value) return;
        if (opacity) value += ', ' + opacity;
        if (typeof console === 'object') {
            console.log(value);
        }
    },
    theme: 'bootstrap'
});

$(".select2").select2();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>